/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.function;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public enum NameForType implements Function<Class<?>, String>
{
    INSTANCE;

    static final String ENHANCER = "$$EnhancerByMockitoWithCGLIB$$";
    static Function<Annotation, String> GET_VALUE;
    static Predicate<Annotation> IS_SUPPORTED;

    static Class<? extends Object> typeOf(Object instance) {
        Class<?> type = instance.getClass();
        while (type.getSimpleName().contains(ENHANCER)) {
            type = type.getSuperclass();
        }
        return type;
    }

    public static String juelNameFor(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance must not be null");
        }
        return NameForType.juelNameFor(NameForType.typeOf(instance));
    }

    public static String juelNameFor(Class<?> type) {
        return INSTANCE.apply(type);
    }

    @Override
    public String apply(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null!");
        }
        Optional<String> value = Stream.of(type.getAnnotations()).filter(IS_SUPPORTED).findFirst().map(GET_VALUE);
        return value.isPresent() && StringUtils.isNotBlank((CharSequence)value.get()) ? value.get() : StringUtils.uncapitalize((String)type.getSimpleName());
    }

    static {
        GET_VALUE = new Function<Annotation, String>(){

            @Override
            @Nullable
            public String apply(Annotation annotation) {
                try {
                    return (String)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                }
                catch (Exception e) {
                    return "";
                }
            }
        };
        IS_SUPPORTED = new Predicate<Annotation>(){
            private final Set<String> NAME_ANNOTATIONS = new HashSet<String>(Arrays.asList("javax.inject.Named", "org.springframework.stereotype.Component", "org.springframework.stereotype.Service"));

            @Override
            public boolean test(@Nullable Annotation a) {
                return this.NAME_ANNOTATIONS.contains(a.annotationType().getName());
            }
        };
    }
}

