/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.cases;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.extension.mockito.QueryMocks;
import org.camunda.bpm.extension.mockito.cases.CaseInstanceFakeBuilder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CaseInstanceFake
implements CaseInstance {
    private boolean disabled;
    private boolean terminated;
    private boolean completed;
    private boolean required;
    private boolean enabled;
    private boolean active;
    private boolean available;
    private final String businessKey;
    private final String id;
    private final String caseInstanceId;
    private final String caseDefinitionId;
    private final String activityId;
    private final String activityName;
    private final String activityType;
    private final String parentId;
    private final String activityDescription;
    private final String tenantId;
    private final VariableMap variables;

    public static CaseInstanceFake randomId() {
        return CaseInstanceFake.id(UUID.randomUUID().toString());
    }

    public static CaseInstanceFake id(String id) {
        return CaseInstanceFake.builder().id(id).build();
    }

    public static CaseInstanceFakeBuilder builder() {
        return new CaseInstanceFakeBuilder();
    }

    public CaseInstanceFake(boolean disabled, boolean terminated, boolean completed, boolean required, boolean enabled, boolean active, boolean available, String businessKey, String id, String caseInstanceId, String caseDefinitionId, String activityId, String activityName, String activityType, String parentId, String activityDescription, String tenantId, VariableMap variables) {
        this.disabled = disabled;
        this.terminated = terminated;
        this.completed = completed;
        this.required = required;
        this.enabled = enabled;
        this.active = active;
        this.available = available;
        this.businessKey = businessKey;
        this.id = id;
        this.caseInstanceId = caseInstanceId;
        this.caseDefinitionId = caseDefinitionId;
        this.activityId = activityId;
        this.activityName = activityName;
        this.activityType = activityType;
        this.parentId = parentId;
        this.activityDescription = activityDescription;
        this.tenantId = tenantId;
        this.variables = variables;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getId() {
        return this.id;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getActivityDescription() {
        return this.activityDescription;
    }

    public String getParentId() {
        return this.parentId;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public Object getVariable(String key) {
        return this.variables.get((Object)key);
    }

    public CaseInstanceFake setVariable(String key, Object value) {
        this.variables.putValue(key, value);
        return this;
    }

    public String toString() {
        return "CaseInstanceFake{disabled=" + this.disabled + ", terminated=" + this.terminated + ", completed=" + this.completed + ", required=" + this.required + ", enabled=" + this.enabled + ", active=" + this.active + ", available=" + this.available + ", activityDescription='" + this.activityDescription + '\'' + ", activityId='" + this.activityId + '\'' + ", activityName='" + this.activityName + '\'' + ", activityType='" + this.activityType + '\'' + ", businessKey='" + this.businessKey + '\'' + ", id='" + this.id + '\'' + ", caseInstanceId='" + this.caseInstanceId + '\'' + ", caseDefinitionId='" + this.caseDefinitionId + '\'' + ", parentId='" + this.parentId + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }

    public static AtomicReference<CaseInstanceFake> prepareMock(CaseService caseServiceMock, String caseInstanceId) {
        AtomicReference<CaseInstanceFake> caseInstanceFake = new AtomicReference<CaseInstanceFake>();
        Mockito.when((Object)caseServiceMock.createCaseInstanceByKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenAnswer(invocation -> {
            CaseInstanceFakeBuilder builder = CaseInstanceFake.builder().caseInstanceId(caseInstanceId).caseDefinitionId(invocation.getArgument(0) + ":1").businessKey((String)invocation.getArgument(1));
            ((Map)invocation.getArgument(2)).forEach((k, v) -> builder.variable((String)k, v));
            caseInstanceFake.set(builder.build());
            QueryMocks.mockCaseInstanceQuery(caseServiceMock).singleResult(Optional.ofNullable(caseInstanceFake.get()).orElse(null));
            return caseInstanceFake.get();
        });
        Mockito.when((Object)caseServiceMock.getVariable((String)ArgumentMatchers.eq((Object)caseInstanceId), ArgumentMatchers.anyString())).then(invocation -> Optional.ofNullable(caseInstanceFake.get()).map(i -> i.getVariable((String)invocation.getArgument(1))).orElse(null));
        ((CaseService)Mockito.doAnswer(invocation -> {
            ((CaseInstanceFake)caseInstanceFake.get()).setVariable((String)invocation.getArgument(1), invocation.getArgument(2));
            return null;
        }).when((Object)caseServiceMock)).setVariable((String)ArgumentMatchers.eq((Object)caseInstanceId), ArgumentMatchers.anyString(), ArgumentMatchers.any());
        return caseInstanceFake;
    }
}

