/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.delegate;

import java.util.Optional;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.delegate.DelegateCaseVariableInstance;
import org.camunda.bpm.engine.variable.impl.value.AbstractTypedValue;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DelegateCaseVariableInstanceFake
implements DelegateCaseVariableInstance {
    private String id;
    private String name;
    private String eventName;
    private DelegateCaseExecution sourceExecution;
    private ProcessEngine processEngine;
    private ProcessEngineServices processEngineServices;
    private TypedValue typedValue;
    private String processInstanceId;
    private String processDefinitionId;
    private String executionId;
    private String caseInstanceId;
    private String caseExecutionId;
    private String taskId;
    private String activityInstanceId;
    private String errorMessage;
    private String tenantId;

    public DelegateCaseVariableInstanceFake() {
        this(null);
    }

    public DelegateCaseVariableInstanceFake(String id) {
        this.withId(id);
    }

    public DelegateCaseVariableInstanceFake create(String name, TypedValue value) {
        return this.forEvent("create", name, value);
    }

    public DelegateCaseVariableInstanceFake update(String name, TypedValue value) {
        return this.forEvent("update", name, value);
    }

    public DelegateCaseVariableInstanceFake delete(String name, TypedValue typedValue) {
        return this.forEvent("delete", name, typedValue);
    }

    private DelegateCaseVariableInstanceFake forEvent(String eventName, String name, TypedValue value) {
        return this.withEventName(eventName).withName(name).withValue(value);
    }

    public String getEventName() {
        return this.eventName;
    }

    public DelegateCaseVariableInstanceFake withEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public DelegateCaseExecution getSourceExecution() {
        return this.sourceExecution;
    }

    public DelegateCaseVariableInstanceFake withSourceExecution(DelegateCaseExecution sourceExecution) {
        this.sourceExecution = sourceExecution;
        return this;
    }

    public ProcessEngineServices getProcessEngineServices() {
        return this.processEngineServices != null ? this.processEngineServices : (ProcessEngineServices)Optional.ofNullable(this.processEngine).map(ProcessEngineServices.class::cast).orElse(null);
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public DelegateCaseVariableInstanceFake withProcessEngineServices(ProcessEngineServices processEngineServices) {
        this.processEngineServices = processEngineServices;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public DelegateCaseVariableInstanceFake withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DelegateCaseVariableInstanceFake withName(String name) {
        this.name = name;
        return this;
    }

    public String getTypeName() {
        return Optional.ofNullable(this.typedValue).map(TypedValue::getType).map(ValueType::getName).orElse("undefined");
    }

    public Object getValue() {
        return this.typedValue.getValue();
    }

    public TypedValue getTypedValue() {
        return this.typedValue;
    }

    public DelegateCaseVariableInstanceFake withValue(Object value) {
        return this.withValue((TypedValue)new AbstractTypedValue(value, null));
    }

    public DelegateCaseVariableInstanceFake withValue(TypedValue typedValue) {
        this.typedValue = typedValue;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public DelegateCaseVariableInstanceFake withProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public DelegateCaseVariableInstanceFake withProcessDefinitionId() {
        this.processDefinitionId = this.processDefinitionId;
        return this;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public DelegateCaseVariableInstanceFake withExecutionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public DelegateCaseVariableInstanceFake withCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public DelegateCaseVariableInstanceFake withCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public DelegateCaseVariableInstanceFake withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public DelegateCaseVariableInstanceFake withActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public DelegateCaseVariableInstanceFake withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public DelegateCaseVariableInstanceFake withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String toString() {
        return "DelegateCaseVariableInstanceFake{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", eventName='" + this.eventName + '\'' + ", sourceExecution=" + this.sourceExecution + ", processEngineServices=" + this.processEngineServices + ", typedValue=" + this.typedValue + ", processInstanceId='" + this.processInstanceId + '\'' + ", processDefinitionId='" + this.processDefinitionId + '\'' + ", executionId='" + this.executionId + '\'' + ", caseInstanceId='" + this.caseInstanceId + '\'' + ", caseExecutionId='" + this.caseExecutionId + '\'' + ", taskId='" + this.taskId + '\'' + ", activityInstanceId='" + this.activityInstanceId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

