/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.delegate;

import java.util.Date;
import java.util.UUID;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.extension.mockito.delegate.DelegateExecutionFake;

public class IncidentFake
implements Incident {
    private final String id = UUID.randomUUID().toString();
    private final Date timestamp = new Date();
    private final DelegateExecutionFake execution;
    private final String type;
    private final String message;
    private final String configuration;
    private final String jobDefinitionId;
    private final String historyConfiguration;
    private final String failedActivityId;

    public IncidentFake(DelegateExecutionFake execution, String type, String configuration, String message, String jobDefinitionId, String historyConfiguration, String failedActivityId) {
        this.execution = execution;
        this.type = type;
        this.configuration = configuration;
        this.message = message;
        this.jobDefinitionId = jobDefinitionId;
        this.historyConfiguration = historyConfiguration;
        this.failedActivityId = failedActivityId;
    }

    public String getId() {
        return this.id;
    }

    public Date getIncidentTimestamp() {
        return this.timestamp;
    }

    public String getIncidentType() {
        return this.type;
    }

    public String getIncidentMessage() {
        return this.message;
    }

    public String getExecutionId() {
        return this.execution.getId();
    }

    public String getActivityId() {
        return this.execution.getCurrentActivityId();
    }

    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public String getProcessInstanceId() {
        return this.execution.getProcessInstanceId();
    }

    public String getProcessDefinitionId() {
        return this.execution.getProcessDefinitionId();
    }

    public String getCauseIncidentId() {
        return this.id;
    }

    public String getRootCauseIncidentId() {
        return this.id;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getTenantId() {
        return this.execution.getTenantId();
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public String getHistoryConfiguration() {
        return this.historyConfiguration;
    }

    public String toString() {
        return "IncidentFake{id='" + this.id + '\'' + ", timestamp=" + this.timestamp + ", execution=" + (Object)((Object)this.execution) + ", type='" + this.type + '\'' + ", message='" + this.message + '\'' + ", configuration='" + this.configuration + '\'' + ", jobDefinitionId='" + this.jobDefinitionId + '\'' + ", historyConfiguration='" + this.historyConfiguration + '\'' + ", failedActivityId='" + this.failedActivityId + '\'' + '}';
    }
}

