/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.process;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.extension.mockito.Expressions;
import org.camunda.bpm.extension.mockito.function.DeployProcess;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;

public class CallActivityMock {
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final String processId;
    private AbstractFlowNodeBuilder<?, ?> flowNodeBuilder;

    public CallActivityMock(String processId, MockedModelConfigurer modelConfigurer) {
        this.processId = processId;
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)processId);
        if (modelConfigurer != null) {
            modelConfigurer.setProcessModelAttributes(processBuilder);
        }
        this.flowNodeBuilder = processBuilder.startEvent("start");
    }

    public CallActivityMock(String processId) {
        this(processId, null);
    }

    public CallActivityMock onExecutionSetVariables(VariableMap variables) {
        return this.onExecutionDo("setVariablesServiceMock_" + this.randomUUID(), execution -> execution.setVariables((Map)variables));
    }

    public CallActivityMock onExecutionAddVariables(VariableMap variables) {
        return this.onExecutionDo("addVariablesServiceMock_" + this.randomUUID(), execution -> variables.forEach((arg_0, arg_1) -> ((DelegateExecution)execution).setVariable(arg_0, arg_1)));
    }

    public CallActivityMock onExecutionAddVariable(String key, Object val) {
        return this.onExecutionAddVariables(Variables.createVariables().putValue(key, val));
    }

    public CallActivityMock onExecutionDo(Consumer<DelegateExecution> consumer) {
        return this.onExecutionDo("serviceMock_" + this.randomUUID(), consumer);
    }

    public CallActivityMock onExecutionDo(String serviceId, Consumer<DelegateExecution> consumer) {
        this.flowNodeBuilder = this.flowNodeBuilder.serviceTask(serviceId).camundaDelegateExpression("${id}".replace("id", serviceId));
        Expressions.registerInstance(serviceId, consumer::accept);
        return this;
    }

    public CallActivityMock onExecutionWaitForTimerWithDate(Date date) {
        return this.onExecutionWaitForTimerWithDate(this.df.format(date));
    }

    public CallActivityMock onExecutionWaitForTimerWithDate(String iso8601date) {
        this.flowNodeBuilder = this.flowNodeBuilder.intermediateCatchEvent().timerWithDate(iso8601date);
        return this;
    }

    public CallActivityMock onExecutionWaitForTimerWithDuration(String iso8601duration) {
        this.flowNodeBuilder = this.flowNodeBuilder.intermediateCatchEvent().timerWithDuration(iso8601duration);
        return this;
    }

    public CallActivityMock onExecutionSendMessage(String message) {
        return this.onExecutionDo(execution -> execution.getProcessEngineServices().getRuntimeService().correlateMessage(message));
    }

    public CallActivityMock onExecutionSendMessage(String message, String businessId) {
        return this.onExecutionDo(execution -> execution.getProcessEngineServices().getRuntimeService().correlateMessage(message, businessId));
    }

    public CallActivityMock onExecutionWaitForMessage(String message) {
        this.flowNodeBuilder = this.flowNodeBuilder.intermediateCatchEvent().message(message);
        return this;
    }

    public CallActivityMock onExecutionRunIntoError(Throwable exception) {
        return this.onExecutionDo("throwErrorServiceMock", execution -> {
            throw new RuntimeException(exception);
        });
    }

    public CallActivityMock onExecutionWaitForSignal(String signalName) {
        this.flowNodeBuilder = this.flowNodeBuilder.intermediateCatchEvent().signal(signalName);
        return this;
    }

    public Deployment deploy(RepositoryService repositoryService) {
        return new DeployProcess(repositoryService).apply(this.processId, this.flowNodeBuilder.endEvent("end").done());
    }

    public Deployment deploy(ProcessEngineServices processEngineServices) {
        return this.deploy(processEngineServices.getRepositoryService());
    }

    private String randomUUID() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    @FunctionalInterface
    public static interface MockedModelConfigurer {
        public void setProcessModelAttributes(ProcessBuilder var1);
    }
}

