/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.extension.mockito.answer.FluentAnswer;
import org.mockito.Mockito;

abstract class AbstractQueryMock<M extends AbstractQueryMock<M, Q, R, S>, Q extends Query<?, R>, R, S>
implements Supplier<Q> {
    private final Q query;
    private final Method createMethod;

    protected AbstractQueryMock(@Nonnull Class<Q> queryType, @Nonnull Class<S> serviceType) {
        this.query = FluentAnswer.createMock(queryType);
        this.createMethod = this.createMethod(queryType, serviceType);
        this.list(new ArrayList());
        this.singleResult(null);
    }

    private Method createMethod(@Nonnull Class<Q> queryType, @Nonnull Class<S> serviceType) {
        try {
            return serviceType.getDeclaredMethod("create" + queryType.getSimpleName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Q list(List<R> result) {
        Mockito.when((Object)this.query.list()).thenReturn(result);
        return this.get();
    }

    public Q singleResult(R result) {
        Mockito.when((Object)this.query.singleResult()).thenReturn(result);
        return this.get();
    }

    public Q count(long result) {
        Mockito.when((Object)this.query.count()).thenReturn((Object)result);
        return this.get();
    }

    public Q listPage(List<R> result, int min, int max) {
        Mockito.when((Object)this.query.listPage(min, max)).thenReturn(result);
        return this.get();
    }

    public M forService(S service) {
        try {
            Mockito.when((Object)this.createMethod.invoke(service, new Object[0])).thenReturn(this.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (M)this;
    }

    @Override
    public final Q get() {
        return this.query;
    }
}

