/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.mock;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.util.Map;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.mockito.Mockito;

public abstract class FluentMock<T, P extends VariableScope> {
    protected final T mock;
    protected final Class<P> parameterType;

    protected FluentMock(T mock, Class<P> parameterType) {
        this.mock = mock;
        this.parameterType = parameterType;
    }

    protected void setVariables(VariableScope variableScope, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            variableScope.setVariable(variable.getKey(), variable.getValue());
        }
    }

    public abstract void onExecutionSetVariables(VariableMap var1);

    public void onExecutionSetVariable(String key, Object value) {
        this.onExecutionSetVariables(Variables.putValue((String)key, (Object)value));
    }

    public <V> void onExecutionSetVariable(VariableFactory<V> variable, V value) {
        this.onExecutionSetVariable(variable.getName(), value);
    }

    public void onExecutionSetVariables(Map<String, Object> variables) {
        this.onExecutionSetVariables(Variables.fromMap(variables));
    }

    public void onExecutionThrowBpmnError(String errorCode) {
        this.onExecutionThrowBpmnError(new BpmnError(errorCode));
    }

    public void onExecutionThrowBpmnError(String errorCode, String message) {
        this.onExecutionThrowBpmnError(new BpmnError(errorCode, message));
    }

    public abstract void onExecutionThrowBpmnError(BpmnError var1);

    public abstract void onExecutionThrowException(Exception var1);

    public T getMock() {
        return this.mock;
    }

    protected P any() {
        return (P)((VariableScope)Mockito.any(this.parameterType));
    }
}

