/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.process;

import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.extension.mockito.process.CallActivityMock;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CallActivityMockForSpringContext
extends CallActivityMock {
    private SingletonBeanRegistry springBeanRegistry;

    public CallActivityMockForSpringContext(String processId, CallActivityMock.MockedModelConfigurer modelConfigurer, SingletonBeanRegistry springBeanRegistry) {
        super(processId, modelConfigurer);
        this.springBeanRegistry = springBeanRegistry;
    }

    public CallActivityMockForSpringContext(String processId, CallActivityMock.MockedModelConfigurer modelConfigurer, ApplicationContext applicationContext) {
        this(processId, modelConfigurer, CallActivityMockForSpringContext.getSingletonBeanRegistry(applicationContext));
    }

    public CallActivityMockForSpringContext(String processId, SingletonBeanRegistry springBeanRegistry) {
        this(processId, null, springBeanRegistry);
    }

    public CallActivityMockForSpringContext(String processId, ApplicationContext applicationContext) {
        this(processId, CallActivityMockForSpringContext.getSingletonBeanRegistry(applicationContext));
    }

    private static SingletonBeanRegistry getSingletonBeanRegistry(ApplicationContext applicationContext) {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalArgumentException("applicationContext is not an instance of ConfigurableApplicationContext");
        }
        return ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
    }

    public SingletonBeanRegistry getSpringBeanRegistry() {
        return this.springBeanRegistry;
    }

    @Override
    protected void registerJavaDelegateMock(String delegateReferenceName, JavaDelegate delegate) {
        this.springBeanRegistry.registerSingleton(delegateReferenceName, (Object)delegate);
    }
}

