/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito;

import java.net.URL;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.extension.mockito.DelegateExpressions;
import org.camunda.bpm.extension.mockito.Expressions;
import org.camunda.bpm.extension.mockito.ProcessExpressions;
import org.camunda.bpm.extension.mockito.QueryMocks;
import org.camunda.bpm.extension.mockito.delegate.DelegateCaseExecutionFake;
import org.camunda.bpm.extension.mockito.delegate.DelegateCaseVariableInstanceFake;
import org.camunda.bpm.extension.mockito.delegate.DelegateExecutionFake;
import org.camunda.bpm.extension.mockito.delegate.DelegateTaskFake;
import org.camunda.bpm.extension.mockito.delegate.VariableScopeFake;
import org.camunda.bpm.extension.mockito.function.NameForType;
import org.camunda.bpm.extension.mockito.mock.FluentExecutionListenerMock;
import org.camunda.bpm.extension.mockito.mock.FluentJavaDelegateMock;
import org.camunda.bpm.extension.mockito.mock.FluentTaskListenerMock;
import org.camunda.bpm.extension.mockito.process.CallActivityMock;
import org.camunda.bpm.extension.mockito.query.ActivityStatisticsQueryMock;
import org.camunda.bpm.extension.mockito.query.AuthorizationQueryMock;
import org.camunda.bpm.extension.mockito.query.BatchQueryMock;
import org.camunda.bpm.extension.mockito.query.BatchStatisticsQueryMock;
import org.camunda.bpm.extension.mockito.query.CaseDefinitionQueryMock;
import org.camunda.bpm.extension.mockito.query.CaseExecutionQueryMock;
import org.camunda.bpm.extension.mockito.query.CaseInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.DecisionDefinitionQueryMock;
import org.camunda.bpm.extension.mockito.query.DeploymentQueryMock;
import org.camunda.bpm.extension.mockito.query.DeploymentStatisticsQueryMock;
import org.camunda.bpm.extension.mockito.query.EventSubscriptionQueryMock;
import org.camunda.bpm.extension.mockito.query.ExecutionQueryMock;
import org.camunda.bpm.extension.mockito.query.ExternalTaskQueryMock;
import org.camunda.bpm.extension.mockito.query.FilterQueryMock;
import org.camunda.bpm.extension.mockito.query.GroupQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricActivityStatisticsQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricBatchQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricCaseActivityInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricCaseInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricDecisionInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricDetailQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricIdentityLinkLogQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricIncidentQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricJobLogQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricProcessInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricTaskInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.HistoricVariableInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.IncidentQueryMock;
import org.camunda.bpm.extension.mockito.query.JobDefinitionQueryMock;
import org.camunda.bpm.extension.mockito.query.JobQueryMock;
import org.camunda.bpm.extension.mockito.query.ProcessDefinitionQueryMock;
import org.camunda.bpm.extension.mockito.query.ProcessDefinitionStatisticsQueryMock;
import org.camunda.bpm.extension.mockito.query.ProcessInstanceQueryMock;
import org.camunda.bpm.extension.mockito.query.TaskQueryMock;
import org.camunda.bpm.extension.mockito.query.TenantQueryMock;
import org.camunda.bpm.extension.mockito.query.UserOperationLogQueryMock;
import org.camunda.bpm.extension.mockito.query.UserQueryMock;
import org.camunda.bpm.extension.mockito.query.VariableInstanceQueryMock;
import org.camunda.bpm.extension.mockito.service.RuntimeServiceFluentMock;
import org.camunda.bpm.extension.mockito.verify.MockitoVerification;

public enum CamundaMockito {


    public static void autoMock(@Nonnull String bpmnFileResource) {
        DelegateExpressions.autoMock(bpmnFileResource);
    }

    public static void autoMock(@Nonnull URL bpmnFile) {
        DelegateExpressions.autoMock(bpmnFile);
    }

    public static FluentJavaDelegateMock registerJavaDelegateMock(String name) {
        return DelegateExpressions.registerJavaDelegateMock(name);
    }

    public static FluentJavaDelegateMock registerJavaDelegateMock(Class<? extends JavaDelegate> type) {
        return DelegateExpressions.registerJavaDelegateMock(type);
    }

    public static FluentExecutionListenerMock registerExecutionListenerMock(String name) {
        return Expressions.registerInstance(name, new FluentExecutionListenerMock());
    }

    public static FluentExecutionListenerMock registerExecutionListenerMock(Class<? extends ExecutionListener> type) {
        return DelegateExpressions.registerExecutionListenerMock(NameForType.juelNameFor(type));
    }

    public static FluentTaskListenerMock registerTaskListenerMock(String name) {
        return Expressions.registerInstance(name, new FluentTaskListenerMock());
    }

    public static FluentTaskListenerMock registerTaskListenerMock(Class<? extends TaskListener> type) {
        return DelegateExpressions.registerTaskListenerMock(NameForType.juelNameFor(type));
    }

    public static FluentJavaDelegateMock getJavaDelegateMock(String name) {
        return (FluentJavaDelegateMock)Expressions.getRegistered(name);
    }

    public static FluentJavaDelegateMock getJavaDelegateMock(Class<?> type) {
        return (FluentJavaDelegateMock)Expressions.getRegistered(type);
    }

    public static FluentExecutionListenerMock getExecutionListenerMock(String name) {
        return (FluentExecutionListenerMock)Expressions.getRegistered(name);
    }

    public static FluentExecutionListenerMock getExecutionListenerMock(Class<?> type) {
        return (FluentExecutionListenerMock)Expressions.getRegistered(type);
    }

    public static FluentTaskListenerMock getTaskListenerMock(String name) {
        return (FluentTaskListenerMock)Expressions.getRegistered(name);
    }

    public static FluentTaskListenerMock getTaskListenerMock(Class<?> type) {
        return (FluentTaskListenerMock)Expressions.getRegistered(type);
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(String name) {
        return DelegateExpressions.verifyJavaDelegateMock(name);
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(Class<?> type) {
        return DelegateExpressions.verifyJavaDelegateMock(type);
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(FluentJavaDelegateMock fluentJavaDelegateMock) {
        return DelegateExpressions.verifyJavaDelegateMock(fluentJavaDelegateMock);
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(String name) {
        return DelegateExpressions.verifyExecutionListenerMock(name);
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(Class<?> type) {
        return DelegateExpressions.verifyExecutionListenerMock(type);
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(FluentExecutionListenerMock fluentExecutionListenerMock) {
        return DelegateExpressions.verifyExecutionListenerMock(fluentExecutionListenerMock);
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(String name) {
        return DelegateExpressions.verifyTaskListenerMock(name);
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(Class<?> type) {
        return DelegateExpressions.verifyTaskListenerMock(type);
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(FluentTaskListenerMock fluentTaskListenerMock) {
        return DelegateExpressions.verifyTaskListenerMock(fluentTaskListenerMock);
    }

    public static void registerMockInstancesForNestedTypes(Class<?> parentClass) {
        Expressions.registerMockInstancesForNestedTypes(parentClass);
    }

    public static void registerInstancesForFields(Object instance) {
        Expressions.registerInstancesForFields(instance);
    }

    public static void registerNewInstancesForNestedTypes(Class<?> parentClass) {
        Expressions.registerMockInstancesForNestedTypes(parentClass);
    }

    public static void registerMockInstances(Class<?> ... types) {
        Expressions.registerMockInstances(types);
    }

    public static void registerMockInstances(Collection<Class<?>> types) {
        Expressions.registerMockInstances(types);
    }

    public static <T> T registerMockInstance(String name, Class<T> type) {
        return Expressions.registerMockInstance(name, type);
    }

    public static <T> T registerMockInstance(Class<T> type) {
        return Expressions.registerMockInstance(type);
    }

    public static <T> T registerNewInstance(String name, Class<T> type) {
        return Expressions.registerNewInstance(name, type);
    }

    public static <T> T registerNewInstance(Class<T> type) {
        return Expressions.registerNewInstance(type);
    }

    public static <T> T registerInstance(T instance) {
        return Expressions.registerInstance(instance);
    }

    public static <T> T registerInstance(String name, T instance) {
        return Expressions.registerInstance(name, instance);
    }

    public static <T> T getRegistered(String name) {
        return Expressions.getRegistered(name);
    }

    public static <T> T getRegistered(Class<?> type) {
        return Expressions.getRegistered(type);
    }

    public static void reset() {
        Mocks.reset();
    }

    public static FilterQueryMock mockFilterQuery(FilterService serviceMock) {
        return QueryMocks.mockFilterQuery(serviceMock);
    }

    public static TaskQueryMock mockTaskQuery(TaskService serviceMock) {
        return QueryMocks.mockTaskQuery(serviceMock);
    }

    public static CaseInstanceQueryMock mockCaseInstanceQuery(CaseService serviceMock) {
        return QueryMocks.mockCaseInstanceQuery(serviceMock);
    }

    public static CaseExecutionQueryMock mockCaseExecutionQuery(CaseService serviceMock) {
        return QueryMocks.mockCaseExecutionQuery(serviceMock);
    }

    public static ExecutionQueryMock mockExecutionQuery(RuntimeService serviceMock) {
        return QueryMocks.mockExecutionQuery(serviceMock);
    }

    public static ProcessInstanceQueryMock mockProcessInstanceQuery(RuntimeService serviceMock) {
        return QueryMocks.mockProcessInstanceQuery(serviceMock);
    }

    public static IncidentQueryMock mockIncidentQuery(RuntimeService serviceMock) {
        return QueryMocks.mockIncidentQuery(serviceMock);
    }

    public static EventSubscriptionQueryMock mockEventSubscriptionQuery(RuntimeService serviceMock) {
        return QueryMocks.mockEventSubscriptionQuery(serviceMock);
    }

    public static VariableInstanceQueryMock mockVariableInstanceQuery(RuntimeService serviceMock) {
        return QueryMocks.mockVariableInstanceQuery(serviceMock);
    }

    public static ProcessDefinitionQueryMock mockProcessDefinitionQuery(RepositoryService serviceMock) {
        return QueryMocks.mockProcessDefinitionQuery(serviceMock);
    }

    public static CaseDefinitionQueryMock mockCaseDefinitionQuery(RepositoryService serviceMock) {
        return QueryMocks.mockCaseDefinitionQuery(serviceMock);
    }

    public static DecisionDefinitionQueryMock mockDecisionDefinitionQuery(RepositoryService serviceMock) {
        return QueryMocks.mockDecisionDefinitionQuery(serviceMock);
    }

    public static DeploymentQueryMock mockDeploymentQuery(RepositoryService serviceMock) {
        return QueryMocks.mockDeploymentQuery(serviceMock);
    }

    public static HistoricIdentityLinkLogQueryMock mockHistoricIdentityLinkLogQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricIdentityLinkLogQuery(serviceMock);
    }

    public static HistoricProcessInstanceQueryMock mockHistoricProcessInstanceQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricProcessInstanceQuery(serviceMock);
    }

    public static HistoricActivityStatisticsQueryMock mockHistoricActivityStatisticsQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricActivityStatisticsQuery(serviceMock);
    }

    public static HistoricVariableInstanceQueryMock mockHistoricVariableInstanceQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricVariableInstanceQuery(serviceMock);
    }

    public static HistoricCaseActivityInstanceQueryMock mockHistoricCaseActivityInstanceQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricCaseActivityInstanceQuery(serviceMock);
    }

    public static HistoricDecisionInstanceQueryMock mockHistoricDecisionInstanceQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricDecisionInstanceQuery(serviceMock);
    }

    public static HistoricTaskInstanceQueryMock mockHistoricTaskInstanceQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricTaskInstanceQuery(serviceMock);
    }

    public static HistoricDetailQueryMock mockHistoricDetailQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricDetailQuery(serviceMock);
    }

    public static UserOperationLogQueryMock mockUserOperationLogQuery(HistoryService serviceMock) {
        return QueryMocks.mockUserOperationLogQuery(serviceMock);
    }

    public static HistoricIncidentQueryMock mockHistoricIncidentQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricIncidentQuery(serviceMock);
    }

    public static HistoricCaseInstanceQueryMock mockHistoricCaseInstanceQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricCaseInstanceQuery(serviceMock);
    }

    public static HistoricJobLogQueryMock mockHistoricJobLogQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricJobLogQuery(serviceMock);
    }

    public static HistoricBatchQueryMock mockHistoricBatchQuery(HistoryService serviceMock) {
        return QueryMocks.mockHistoricBatchQuery(serviceMock);
    }

    public static UserQueryMock mockUserQuery(IdentityService serviceMock) {
        return QueryMocks.mockUserQuery(serviceMock);
    }

    public static GroupQueryMock mockGroupQuery(IdentityService serviceMock) {
        return QueryMocks.mockGroupQuery(serviceMock);
    }

    public static TenantQueryMock mockTenantQuery(IdentityService serviceMock) {
        return QueryMocks.mockTenantQuery(serviceMock);
    }

    public static JobQueryMock mockJobQuery(ManagementService serviceMock) {
        return QueryMocks.mockJobQuery(serviceMock);
    }

    public static BatchQueryMock mockBatchQuery(ManagementService serviceMock) {
        return QueryMocks.mockBatchQuery(serviceMock);
    }

    public static ProcessDefinitionStatisticsQueryMock mockProcessDefinitionStatisticsQuery(ManagementService serviceMock) {
        return QueryMocks.mockProcessDefinitionStatisticsQuery(serviceMock);
    }

    public static JobDefinitionQueryMock mockJobDefinitionQuery(ManagementService serviceMock) {
        return QueryMocks.mockJobDefinitionQuery(serviceMock);
    }

    public static DeploymentStatisticsQueryMock mockDeploymentStatisticsQuery(ManagementService serviceMock) {
        return QueryMocks.mockDeploymentStatisticsQuery(serviceMock);
    }

    public static ActivityStatisticsQueryMock mockActivityStatisticsQuery(ManagementService serviceMock) {
        return QueryMocks.mockActivityStatisticsQuery(serviceMock);
    }

    public static BatchStatisticsQueryMock mockBatchStatisticsQuery(ManagementService serviceMock) {
        return QueryMocks.mockBatchStatisticsQuery(serviceMock);
    }

    public static AuthorizationQueryMock mockAuthorizationQuery(AuthorizationService serviceMock) {
        return QueryMocks.mockAuthorizationQuery(serviceMock);
    }

    public static ExternalTaskQueryMock mockExternalTaskQuery(ExternalTaskService serviceMock) {
        return QueryMocks.mockExternalTaskQuery(serviceMock);
    }

    public static VariableScopeFake variableScopeFake() {
        return new VariableScopeFake(){};
    }

    public static DelegateExecutionFake delegateExecutionFake() {
        return new DelegateExecutionFake();
    }

    public static DelegateCaseExecutionFake delegateCaseExecutionFake() {
        return new DelegateCaseExecutionFake();
    }

    public static DelegateCaseVariableInstanceFake delegateCaseVariableInstanceFake() {
        return new DelegateCaseVariableInstanceFake();
    }

    public static DelegateTaskFake delegateTaskFake() {
        return new DelegateTaskFake();
    }

    public static Set<String> candidateUserIds(DelegateTask task) {
        return DelegateTaskFake.candidateUserIds(task);
    }

    public static Set<String> candidateGroupIds(DelegateTask task) {
        return DelegateTaskFake.candidateGroupIds(task);
    }

    public static CallActivityMock registerCallActivityMock(String processDefinitionKey) {
        return ProcessExpressions.registerCallActivityMock(processDefinitionKey);
    }

    public static RuntimeServiceFluentMock runtimeServiceFluentMock() {
        return new RuntimeServiceFluentMock();
    }

    public static RuntimeServiceFluentMock runtimeServiceFluentMock(RuntimeService runtimeServiceMock) {
        return new RuntimeServiceFluentMock(runtimeServiceMock);
    }
}

