/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.blueprint;

import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;

public class BlueprintELResolver
extends ELResolver {
    private static final Logger LOGGER = Logger.getLogger(BlueprintELResolver.class.getName());
    private Map<String, JavaDelegate> delegateMap = new HashMap<String, JavaDelegate>();
    private Map<String, TaskListener> taskListenerMap = new HashMap<String, TaskListener>();
    private Map<String, ActivityBehavior> activityBehaviourMap = new HashMap<String, ActivityBehavior>();

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            String key = (String)property;
            for (String name : this.delegateMap.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                context.setPropertyResolved(true);
                return this.delegateMap.get(name);
            }
            for (String name : this.taskListenerMap.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                context.setPropertyResolved(true);
                return this.taskListenerMap.get(name);
            }
            for (String name : this.activityBehaviourMap.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                context.setPropertyResolved(true);
                return this.activityBehaviourMap.get(name);
            }
        }
        return null;
    }

    public void bindService(JavaDelegate delegate, Map<?, ?> props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        this.delegateMap.put(name, delegate);
        LOGGER.info("added service to delegate cache " + name);
    }

    public void unbindService(JavaDelegate delegate, Map<?, ?> props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        if (this.delegateMap.containsKey(name)) {
            this.delegateMap.remove(name);
        }
        LOGGER.info("removed service from delegate cache " + name);
    }

    public void bindTaskListenerService(TaskListener delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        this.taskListenerMap.put(name, delegate);
        LOGGER.info("added service to taskListener cache " + name);
    }

    public void unbindTaskListenerService(TaskListener delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        if (this.taskListenerMap.containsKey(name)) {
            this.taskListenerMap.remove(name);
        }
        LOGGER.info("removed Camunda service from taskListener cache " + name);
    }

    public void bindActivityBehaviourService(ActivityBehavior delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        this.activityBehaviourMap.put(name, delegate);
        LOGGER.info("added service to activityBehaviour cache " + name);
    }

    public void unbindActivityBehaviourService(ActivityBehavior delegate, Map props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        if (this.activityBehaviourMap.containsKey(name)) {
            this.activityBehaviourMap.remove(name);
        }
        LOGGER.info("removed Camunda service from activityBehaviour cache " + name);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    public Class<?> getCommonPropertyType(ELContext context, Object arg) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object arg) {
        return null;
    }

    public Class<?> getType(ELContext context, Object arg1, Object arg2) {
        return Object.class;
    }
}

