/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import org.jledit.ConsoleEditor;
import org.jledit.command.editor.AbstractUndoableCommand;
import org.jledit.command.editor.DeleteType;

public class DeleteCommand
extends AbstractUndoableCommand {
    private final DeleteType type;
    private String deleted;

    public DeleteCommand(ConsoleEditor editor) {
        this(editor, DeleteType.CHARACTER);
    }

    public DeleteCommand(ConsoleEditor editor, DeleteType type) {
        super(editor);
        this.type = type;
    }

    @Override
    public void doExecute() {
        if (!this.getEditor().isReadOnly()) {
            StringBuilder deletedBuilder = new StringBuilder();
            String currentLine = (String)this.getEditor().getContent(this.getEditor().getLine());
            int charsToDelete = 1;
            switch (this.type) {
                case CHARACTER: {
                    charsToDelete = 1;
                    break;
                }
                case LINE: {
                    this.getEditor().moveToStartOfLine();
                }
                case TO_END_OF_LINE: {
                    charsToDelete = currentLine.length() - this.getEditor().getColumn() - 1;
                }
            }
            for (int c = 0; c < charsToDelete; ++c) {
                deletedBuilder.append(this.getEditor().delete());
            }
            this.deleted = deletedBuilder.toString();
            if (this.deleted != null && !this.deleted.isEmpty()) {
                this.getEditor().setDirty(true);
            }
        }
    }

    @Override
    public void undo() {
        if (!this.getEditor().isReadOnly()) {
            switch (this.type) {
                case CHARACTER: 
                case TO_END_OF_LINE: {
                    this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
                    break;
                }
                case LINE: {
                    this.getEditor().move(this.getBeforeLine(), 1);
                }
            }
            this.getEditor().put(this.deleted);
        }
    }
}

