/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.activator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import org.apache.servicemix.specs.activator.OsgiMailcapCommandMap;
import org.apache.servicemix.specs.locator.OsgiLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static boolean debug = false;
    private ConcurrentMap<Long, Map<String, Callable<Class>>> factories = new ConcurrentHashMap<Long, Map<String, Callable<Class>>>();
    private BundleContext bundleContext;
    private Map<Long, MailCap> mailcaps = new ConcurrentHashMap<Long, MailCap>();

    protected void debugPrintln(String msg) {
        if (debug) {
            System.err.println("Spec(" + this.bundleContext.getBundle().getBundleId() + "): " + msg);
        }
    }

    public synchronized void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.debugPrintln("activating");
        this.debugPrintln("adding bundle listener");
        bundleContext.addBundleListener((BundleListener)this);
        this.debugPrintln("checking existing bundles");
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.register(bundle);
        }
        this.debugPrintln("activated");
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        this.debugPrintln("deactivating");
        bundleContext.removeBundleListener((BundleListener)this);
        while (!this.factories.isEmpty()) {
            this.unregister((Long)this.factories.keySet().iterator().next());
        }
        this.debugPrintln("deactivated");
        this.bundleContext = null;
        CommandMap.setDefaultCommandMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Activator activator = this;
        synchronized (activator) {
            if (this.bundleContext == null) {
                return;
            }
        }
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    protected void register(Bundle bundle) {
        URL url;
        this.debugPrintln("checking bundle " + bundle.getBundleId());
        HashMap<String, BundleFactoryLoader> map = (HashMap<String, BundleFactoryLoader>)this.factories.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                String url2 = u.toString();
                if (url2.endsWith("/")) continue;
                String factoryId = url2.substring(url2.lastIndexOf("/") + 1);
                if (map == null) {
                    map = new HashMap<String, BundleFactoryLoader>();
                    this.factories.put(bundle.getBundleId(), map);
                }
                map.put(factoryId, new BundleFactoryLoader(factoryId, u, bundle));
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.debugPrintln("registering service for key " + (String)entry.getKey() + " with value " + entry.getValue());
                OsgiLocator.register((String)((String)entry.getKey()), (Callable)((Callable)entry.getValue()));
            }
        }
        if ((url = bundle.getResource("/META-INF/mailcap")) != null) {
            this.debugPrintln("found mailcap at " + url);
            try {
                Class clazz = bundle.loadClass("javax.activation.DataContentHandler");
                if (!clazz.isAssignableFrom(DataContentHandler.class)) {
                    this.debugPrintln("incompatible DataContentHandler class in bundle " + bundle.getBundleId());
                    return;
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            try {
                this.mailcaps.put(bundle.getBundleId(), new MailCap(bundle, url));
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.rebuildCommandMap();
        }
    }

    protected void unregister(long bundleId) {
        MailCap mailcap;
        Map map = (Map)this.factories.remove(bundleId);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.debugPrintln("unregistering service for key " + (String)entry.getKey() + " with value " + entry.getValue());
                OsgiLocator.unregister((String)((String)entry.getKey()), (Callable)((Callable)entry.getValue()));
            }
        }
        if ((mailcap = this.mailcaps.remove(bundleId)) != null) {
            this.debugPrintln("removing mailcap for bundle " + mailcap.bundle.getBundleId());
            this.rebuildCommandMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildCommandMap() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            OsgiMailcapCommandMap commandMap = new OsgiMailcapCommandMap();
            for (MailCap mailcap : this.mailcaps.values()) {
                for (String line : mailcap.lines) {
                    commandMap.addMailcap(line, mailcap.bundle);
                }
            }
            CommandMap.setDefaultCommandMap((CommandMap)commandMap);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static {
        try {
            String prop = System.getProperty("org.apache.servicemix.specs.debug");
            debug = prop != null && !"false".equals(prop);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class MailCap {
        Bundle bundle;
        List<String> lines;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MailCap(Bundle bundle, URL url) throws IOException {
            this.bundle = bundle;
            this.lines = new ArrayList<String>();
            InputStream is = url.openStream();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleFactoryLoader
    implements Callable<Class> {
        private final String factoryId;
        private final URL u;
        private final Bundle bundle;
        private volatile Class<?> clazz;

        public BundleFactoryLoader(String factoryId, URL u, Bundle bundle) {
            this.factoryId = factoryId;
            this.u = u;
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class call() throws Exception {
            try {
                Activator.this.debugPrintln("loading factory for key: " + this.factoryId);
                if (this.clazz == null) {
                    BundleFactoryLoader bundleFactoryLoader = this;
                    synchronized (bundleFactoryLoader) {
                        if (this.clazz == null) {
                            Activator.this.debugPrintln("creating factory for key: " + this.factoryId);
                            BufferedReader br = new BufferedReader(new InputStreamReader(this.u.openStream(), "UTF-8"));
                            try {
                                String factoryClassName = br.readLine();
                                while (factoryClassName != null) {
                                    if ((factoryClassName = factoryClassName.trim()).charAt(0) != '#') {
                                        Activator.this.debugPrintln("factory implementation: " + factoryClassName);
                                        this.clazz = this.bundle.loadClass(factoryClassName);
                                        Class<?> clazz = this.clazz;
                                        return clazz;
                                    }
                                    factoryClassName = br.readLine();
                                }
                            }
                            finally {
                                br.close();
                            }
                        }
                    }
                }
                return this.clazz;
            }
            catch (Exception e) {
                Activator.this.debugPrintln("exception caught while creating factory: " + e);
                throw e;
            }
            catch (Error e) {
                Activator.this.debugPrintln("error caught while creating factory: " + e);
                throw e;
            }
        }

        public String toString() {
            return this.u.toString();
        }

        public int hashCode() {
            return this.u.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BundleFactoryLoader) {
                return this.u.equals(((BundleFactoryLoader)obj).u);
            }
            return false;
        }
    }
}

