/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import org.apache.karaf.bundle.command.BundleCommand;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="dynamic-import", description="Enables/disables dynamic-import for a given bundle.")
public class DynamicImport
extends BundleCommand {
    public DynamicImport() {
        super(true);
    }

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        if (this.bundleService.isDynamicImport(bundle)) {
            System.out.printf("Disabling dynamic imports on bundle %s%n", bundle);
            this.bundleService.disableDynamicImports(bundle);
        } else {
            System.out.printf("Enabling dynamic imports on bundle %s%n", bundle);
            this.bundleService.enableDynamicImports(bundle);
        }
    }
}

