/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.impl.instance;

import java.util.Collection;
import java.util.HashSet;
import org.camunda.bpm.model.bpmn.BpmnModelException;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.camunda.bpm.model.bpmn.impl.QueryImpl;
import org.camunda.bpm.model.bpmn.impl.instance.FlowElementImpl;
import org.camunda.bpm.model.bpmn.impl.instance.Incoming;
import org.camunda.bpm.model.bpmn.impl.instance.Outgoing;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementTypeBuilder;
import org.camunda.bpm.model.xml.type.attribute.Attribute;
import org.camunda.bpm.model.xml.type.child.SequenceBuilder;
import org.camunda.bpm.model.xml.type.reference.AttributeReference;
import org.camunda.bpm.model.xml.type.reference.ElementReferenceCollection;
import org.camunda.bpm.model.xml.type.reference.Reference;

public abstract class FlowNodeImpl
extends FlowElementImpl
implements FlowNode {
    protected static ElementReferenceCollection<SequenceFlow, Incoming> incomingCollection;
    protected static ElementReferenceCollection<SequenceFlow, Outgoing> outgoingCollection;
    protected static Attribute<Boolean> camundaAsyncAfter;
    protected static Attribute<Boolean> camundaAsyncBefore;
    protected static Attribute<Boolean> camundaExclusive;

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(FlowNode.class, "flowNode").namespaceUri("http://www.omg.org/spec/BPMN/20100524/MODEL").extendsType(FlowElement.class).abstractType();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        incomingCollection = sequenceBuilder.elementCollection(Incoming.class).qNameElementReferenceCollection(SequenceFlow.class).build();
        outgoingCollection = sequenceBuilder.elementCollection(Outgoing.class).qNameElementReferenceCollection(SequenceFlow.class).build();
        camundaAsyncAfter = typeBuilder.booleanAttribute("asyncAfter").namespace("http://activiti.org/bpmn").defaultValue((Object)false).build();
        camundaAsyncBefore = typeBuilder.booleanAttribute("asyncBefore").namespace("http://activiti.org/bpmn").defaultValue((Object)false).build();
        camundaExclusive = typeBuilder.booleanAttribute("exclusive").namespace("http://activiti.org/bpmn").defaultValue((Object)true).build();
        typeBuilder.build();
    }

    public FlowNodeImpl(ModelTypeInstanceContext context) {
        super(context);
    }

    @Override
    public AbstractFlowNodeBuilder builder() {
        throw new BpmnModelException("No builder implemented for type " + this.getElementType().getTypeNamespace() + ":" + this.getElementType().getTypeName());
    }

    public void updateAfterReplacement() {
        super.updateAfterReplacement();
        Collection<Reference> incomingReferences = this.getIncomingReferencesByType(SequenceFlow.class);
        for (Reference reference : incomingReferences) {
            for (ModelElementInstance sourceElement : reference.findReferenceSourceElements((ModelElementInstance)this)) {
                String referenceIdentifier = reference.getReferenceIdentifier(sourceElement);
                if (referenceIdentifier == null || !referenceIdentifier.equals(this.getId()) || !(reference instanceof AttributeReference)) continue;
                String attributeName = ((AttributeReference)reference).getReferenceSourceAttribute().getAttributeName();
                if (attributeName.equals("sourceRef")) {
                    this.getOutgoing().add((SequenceFlow)sourceElement);
                    continue;
                }
                if (!attributeName.equals("targetRef")) continue;
                this.getIncoming().add((SequenceFlow)sourceElement);
            }
        }
    }

    @Override
    public Collection<SequenceFlow> getIncoming() {
        return incomingCollection.getReferenceTargetElements((ModelElementInstanceImpl)this);
    }

    @Override
    public Collection<SequenceFlow> getOutgoing() {
        return outgoingCollection.getReferenceTargetElements((ModelElementInstanceImpl)this);
    }

    @Override
    public Query<FlowNode> getPreviousNodes() {
        HashSet<FlowNode> previousNodes = new HashSet<FlowNode>();
        for (SequenceFlow sequenceFlow : this.getIncoming()) {
            previousNodes.add(sequenceFlow.getSource());
        }
        return new QueryImpl<FlowNode>(previousNodes);
    }

    @Override
    public Query<FlowNode> getSucceedingNodes() {
        HashSet<FlowNode> succeedingNodes = new HashSet<FlowNode>();
        for (SequenceFlow sequenceFlow : this.getOutgoing()) {
            succeedingNodes.add(sequenceFlow.getTarget());
        }
        return new QueryImpl<FlowNode>(succeedingNodes);
    }

    @Override
    public boolean isCamundaAsyncBefore() {
        return (Boolean)camundaAsyncBefore.getValue((ModelElementInstance)this);
    }

    @Override
    public void setCamundaAsyncBefore(boolean isCamundaAsyncBefore) {
        camundaAsyncBefore.setValue((ModelElementInstance)this, (Object)isCamundaAsyncBefore);
    }

    @Override
    public boolean isCamundaAsyncAfter() {
        return (Boolean)camundaAsyncAfter.getValue((ModelElementInstance)this);
    }

    @Override
    public void setCamundaAsyncAfter(boolean isCamundaAsyncAfter) {
        camundaAsyncAfter.setValue((ModelElementInstance)this, (Object)isCamundaAsyncAfter);
    }

    @Override
    public boolean isCamundaExclusive() {
        return (Boolean)camundaExclusive.getValue((ModelElementInstance)this);
    }

    @Override
    public void setCamundaExclusive(boolean isCamundaExclusive) {
        camundaExclusive.setValue((ModelElementInstance)this, (Object)isCamundaExclusive);
    }
}

