/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.instance;

import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.impl.instance.DomElementImpl;
import org.camunda.bpm.model.xml.impl.util.DomUtil;
import org.camunda.bpm.model.xml.impl.util.XmlQName;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomDocumentImpl
implements DomDocument {
    public static final String GENERIC_NS_PREFIX = "ns";
    private final Document document;

    public DomDocumentImpl(Document document) {
        this.document = document;
    }

    @Override
    public DomElement getRootElement() {
        Element documentElement = this.document.getDocumentElement();
        if (documentElement != null) {
            return new DomElementImpl(documentElement);
        }
        return null;
    }

    @Override
    public void setRootElement(DomElement rootElement) {
        Element documentElement = this.document.getDocumentElement();
        Element newDocumentElement = ((DomElementImpl)rootElement).getElement();
        if (documentElement != null) {
            this.document.replaceChild(newDocumentElement, documentElement);
        } else {
            this.document.appendChild(newDocumentElement);
        }
    }

    @Override
    public DomElement createElement(String namespaceUri, String localName) {
        XmlQName xmlQName = new XmlQName(this, namespaceUri, localName);
        Element element = this.document.createElementNS(xmlQName.getNamespaceUri(), xmlQName.getPrefixedName());
        return new DomElementImpl(element);
    }

    @Override
    public DomElement getElementById(String id) {
        Element element = this.document.getElementById(id);
        if (element != null) {
            return new DomElementImpl(element);
        }
        return null;
    }

    @Override
    public List<DomElement> getElementsByNameNs(String namespaceUri, String localName) {
        NodeList elementsByTagNameNS = this.document.getElementsByTagNameNS(namespaceUri, localName);
        return DomUtil.filterNodeListByName(elementsByTagNameNS, namespaceUri, localName);
    }

    @Override
    public DOMSource getDomSource() {
        return new DOMSource(this.document);
    }

    @Override
    public String registerNamespace(String namespaceUri) {
        DomElement rootElement = this.getRootElement();
        if (rootElement != null) {
            return rootElement.registerNamespace(namespaceUri);
        }
        throw new ModelException("Unable to define a new namespace without a root document element");
    }

    @Override
    public void registerNamespace(String prefix, String namespaceUri) {
        DomElement rootElement = this.getRootElement();
        if (rootElement == null) {
            throw new ModelException("Unable to define a new namespace without a root document element");
        }
        rootElement.registerNamespace(prefix, namespaceUri);
    }

    protected String getUnusedGenericNsPrefix() {
        Element documentElement = this.document.getDocumentElement();
        if (documentElement == null) {
            return "ns0";
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (documentElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", GENERIC_NS_PREFIX + i)) continue;
            return GENERIC_NS_PREFIX + i;
        }
        throw new ModelException("Unable to find an unused namespace prefix");
    }

    @Override
    public DomDocument clone() {
        return new DomDocumentImpl((Document)this.document.cloneNode(true));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomDocumentImpl that = (DomDocumentImpl)o;
        return this.document.equals(that.document);
    }

    public int hashCode() {
        return this.document.hashCode();
    }
}

