/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.parser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.ModelValidationException;
import org.camunda.bpm.model.xml.impl.util.DomUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.xml.sax.SAXException;

public abstract class AbstractModelParser {
    private final DocumentBuilderFactory documentBuilderFactory;
    protected SchemaFactory schemaFactory;
    protected Schema schema;

    protected AbstractModelParser() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.configureFactory(dbf);
        this.documentBuilderFactory = dbf;
    }

    protected void configureFactory(DocumentBuilderFactory dbf) {
        dbf.setValidating(true);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setNamespaceAware(true);
    }

    public ModelInstance parseModelFromStream(InputStream inputStream) {
        DomDocument document = DomUtil.parseInputStream(this.documentBuilderFactory, inputStream);
        this.validateModel(document);
        return this.createModelInstance(document);
    }

    public ModelInstance getEmptyModel() {
        DomDocument document = DomUtil.getEmptyDocument(this.documentBuilderFactory);
        return this.createModelInstance(document);
    }

    public void validateModel(DomDocument document) {
        if (this.schema == null) {
            return;
        }
        Validator validator = this.schema.newValidator();
        try {
            validator.validate(document.getDomSource());
        }
        catch (IOException e) {
            throw new ModelValidationException("Error during DOM document validation", e);
        }
        catch (SAXException e) {
            throw new ModelValidationException("DOM document is not valid", e);
        }
    }

    protected abstract ModelInstance createModelInstance(DomDocument var1);
}

