/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.io.PrintStream;
import org.apache.karaf.log.command.LogCommandSupport;
import org.apache.karaf.log.core.LogEventFormatter;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="display", description="Displays log entries.")
public class DisplayLog
extends LogCommandSupport {
    @Option(name="-n", aliases={}, description="Number of entries to display", required=false, multiValued=false)
    protected int entries;
    @Option(name="-p", aliases={}, description="Pattern for formatting the output", required=false, multiValued=false)
    protected String overridenPattern;
    @Option(name="--no-color", description="Disable syntax coloring of log events", required=false, multiValued=false)
    protected boolean noColor;
    @Argument(index=0, name="logger", description="The name of the logger. This can be ROOT, ALL, or the name of a logger specified in the org.ops4j.pax.logger.cfg file.", required=false, multiValued=false)
    String logger;
    protected LogEventFormatter formatter;

    public void setFormatter(LogEventFormatter formatter) {
        this.formatter = formatter;
    }

    protected Object doExecute() throws Exception {
        PrintStream out = System.out;
        Iterable le = this.logService.getEvents(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        for (PaxLoggingEvent event : le) {
            this.printEvent(out, event);
        }
        out.println();
        return null;
    }

    protected boolean checkIfFromRequestedLog(PaxLoggingEvent event) {
        return event.getLoggerName().lastIndexOf(this.logger) >= 0;
    }

    protected void printEvent(PrintStream out, PaxLoggingEvent event) {
        try {
            if (this.logger != null && event != null && this.checkIfFromRequestedLog(event)) {
                out.append(this.formatter.format(event, this.overridenPattern, this.noColor));
            } else if (event != null && this.logger == null) {
                out.append(this.formatter.format(event, this.overridenPattern, this.noColor));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

