/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.compendium.cm.CmManagedProperties;
import org.apache.aries.blueprint.compendium.cm.CmManagedServiceFactory;
import org.apache.aries.blueprint.compendium.cm.CmProperties;
import org.apache.aries.blueprint.compendium.cm.CmPropertyPlaceholder;
import org.apache.aries.blueprint.compendium.cm.ManagedObjectManager;
import org.apache.aries.blueprint.ext.PlaceholdersUtils;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableComponentMetadata;
import org.apache.aries.blueprint.mutable.MutableIdRefMetadata;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.aries.blueprint.utils.ServiceListener;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CmNamespaceHandler
implements NamespaceHandler {
    public static final String BLUEPRINT_NAMESPACE = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String BLUEPRINT_CM_NAMESPACE_1_0 = "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.0.0";
    public static final String BLUEPRINT_CM_NAMESPACE_1_1 = "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.1.0";
    public static final String BLUEPRINT_CM_NAMESPACE_1_2 = "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.2.0";
    public static final String BLUEPRINT_CM_NAMESPACE_1_3 = "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.3.0";
    public static final String BLUEPRINT_EXT_NAMESPACE_V1_0 = "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0";
    public static final String BLUEPRINT_EXT_NAMESPACE_V1_1 = "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.1.0";
    public static final String BLUEPRINT_EXT_NAMESPACE_V1_2 = "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.2.0";
    public static final String PROPERTY_PLACEHOLDER_ELEMENT = "property-placeholder";
    public static final String MANAGED_PROPERTIES_ELEMENT = "managed-properties";
    public static final String MANAGED_SERVICE_FACTORY_ELEMENT = "managed-service-factory";
    public static final String CM_PROPERTIES_ELEMENT = "cm-properties";
    public static final String DEFAULT_PROPERTIES_ELEMENT = "default-properties";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String INTERFACES_ELEMENT = "interfaces";
    public static final String VALUE_ELEMENT = "value";
    public static final String MANAGED_COMPONENT_ELEMENT = "managed-component";
    public static final String LOCATION_ELEMENT = "location";
    public static final String SERVICE_PROPERTIES_ELEMENT = "service-properties";
    public static final String REGISTRATION_LISTENER_ELEMENT = "registration-listener";
    public static final String ID_ATTRIBUTE = "id";
    public static final String SYSTEM_PROPERTIES_NEVER = "never";
    public static final String PERSISTENT_ID_ATTRIBUTE = "persistent-id";
    public static final String PLACEHOLDER_PREFIX_ATTRIBUTE = "placeholder-prefix";
    public static final String PLACEHOLDER_SUFFIX_ATTRIBUTE = "placeholder-suffix";
    public static final String DEFAULTS_REF_ATTRIBUTE = "defaults-ref";
    public static final String UPDATE_STRATEGY_ATTRIBUTE = "update-strategy";
    public static final String UPDATE_METHOD_ATTRIBUTE = "update-method";
    public static final String FACTORY_PID_ATTRIBUTE = "factory-pid";
    public static final String AUTO_EXPORT_ATTRIBUTE = "auto-export";
    public static final String RANKING_ATTRIBUTE = "ranking";
    public static final String INTERFACE_ATTRIBUTE = "interface";
    public static final String UPDATE_ATTRIBUTE = "update";
    public static final String SYSTEM_PROPERTIES_ATTRIBUTE = "system-properties";
    public static final String IGNORE_MISSING_LOCATIONS_ATTRIBUTE = "ignore-missing-locations";
    public static final String AUTO_EXPORT_DISABLED = "disabled";
    public static final String AUTO_EXPORT_INTERFACES = "interfaces";
    public static final String AUTO_EXPORT_CLASS_HIERARCHY = "class-hierarchy";
    public static final String AUTO_EXPORT_ALL = "all-classes";
    public static final String AUTO_EXPORT_DEFAULT = "disabled";
    public static final String RANKING_DEFAULT = "0";
    private static final String MANAGED_OBJECT_MANAGER_NAME = "org.apache.aries.managedObjectManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CmNamespaceHandler.class);
    private static ConfigurationAdmin configAdmin;
    private int idCounter;

    public int getIdCounter() {
        return this.idCounter;
    }

    public void setIdCounter(int idCounter) {
        this.idCounter = idCounter;
    }

    public static ConfigurationAdmin getConfigAdmin() {
        return configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        CmNamespaceHandler.configAdmin = configAdmin;
    }

    public URL getSchemaLocation(String namespace) {
        if (BLUEPRINT_CM_NAMESPACE_1_3.equals(namespace)) {
            return this.getClass().getResource("blueprint-cm-1.3.0.xsd");
        }
        if (BLUEPRINT_CM_NAMESPACE_1_2.equals(namespace)) {
            return this.getClass().getResource("blueprint-cm-1.2.0.xsd");
        }
        if (BLUEPRINT_CM_NAMESPACE_1_1.equals(namespace)) {
            return this.getClass().getResource("blueprint-cm-1.1.0.xsd");
        }
        if (BLUEPRINT_CM_NAMESPACE_1_0.equals(namespace)) {
            return this.getClass().getResource("blueprint-cm-1.0.0.xsd");
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(CmPropertyPlaceholder.class, CmManagedServiceFactory.class, CmManagedProperties.class, CmProperties.class));
    }

    public Metadata parse(Element element, ParserContext context) {
        LOGGER.debug("Parsing element {{}}{}", (Object)element.getNamespaceURI(), (Object)element.getLocalName());
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        this.registerManagedObjectManager(context, registry);
        if (CmNamespaceHandler.nodeNameEquals(element, PROPERTY_PLACEHOLDER_ELEMENT)) {
            return this.parsePropertyPlaceholder(context, element);
        }
        if (CmNamespaceHandler.nodeNameEquals(element, MANAGED_SERVICE_FACTORY_ELEMENT)) {
            return this.parseManagedServiceFactory(context, element);
        }
        if (CmNamespaceHandler.nodeNameEquals(element, CM_PROPERTIES_ELEMENT)) {
            return this.parseCmProperties(context, element);
        }
        throw new ComponentDefinitionException("Unsupported element: " + element.getNodeName());
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        LOGGER.debug("Decorating node {{}}{}", (Object)node.getNamespaceURI(), (Object)node.getLocalName());
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        this.registerManagedObjectManager(context, registry);
        if (node instanceof Element) {
            if (CmNamespaceHandler.nodeNameEquals(node, MANAGED_PROPERTIES_ELEMENT)) {
                return this.decorateManagedProperties(context, (Element)node, component);
            }
            if (CmNamespaceHandler.nodeNameEquals(node, CM_PROPERTIES_ELEMENT)) {
                return this.decorateCmProperties(context, (Element)node, component);
            }
            throw new ComponentDefinitionException("Unsupported element: " + node.getNodeName());
        }
        throw new ComponentDefinitionException("Illegal use of blueprint cm namespace");
    }

    private ComponentMetadata parseCmProperties(ParserContext context, Element element) {
        String id = this.getId(context, element);
        MutableBeanMetadata factoryMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        this.generateIdIfNeeded(context, (MutableComponentMetadata)factoryMetadata);
        factoryMetadata.setScope("singleton");
        factoryMetadata.setRuntimeClass(CmProperties.class);
        factoryMetadata.setInitMethod("init");
        factoryMetadata.setDestroyMethod("destroy");
        factoryMetadata.addProperty("blueprintContainer", (Metadata)CmNamespaceHandler.createRef(context, "blueprintContainer"));
        factoryMetadata.addProperty("configAdmin", (Metadata)this.createConfigurationAdminRef(context));
        factoryMetadata.addProperty("managedObjectManager", (Metadata)CmNamespaceHandler.createRef(context, MANAGED_OBJECT_MANAGER_NAME));
        String persistentId = element.getAttribute(PERSISTENT_ID_ATTRIBUTE);
        factoryMetadata.addProperty("persistentId", (Metadata)CmNamespaceHandler.createValue(context, persistentId));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factoryMetadata);
        MutableBeanMetadata propertiesMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        propertiesMetadata.setId(id);
        propertiesMetadata.setScope("singleton");
        propertiesMetadata.setRuntimeClass(Properties.class);
        propertiesMetadata.setFactoryComponent((Target)CmNamespaceHandler.createRef(context, factoryMetadata.getId()));
        propertiesMetadata.setFactoryComponent((Target)factoryMetadata);
        propertiesMetadata.setFactoryMethod("getProperties");
        propertiesMetadata.setDependsOn(Arrays.asList(factoryMetadata.getId()));
        return propertiesMetadata;
    }

    private ComponentMetadata parsePropertyPlaceholder(ParserContext context, Element element) {
        String systemProperties;
        String ignoreMissingLocations;
        String defaultsRef;
        MutableBeanMetadata metadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        metadata.setProcessor(true);
        metadata.setId(this.getId(context, element));
        metadata.setScope("singleton");
        metadata.setRuntimeClass(CmPropertyPlaceholder.class);
        metadata.setInitMethod("init");
        metadata.setDestroyMethod("destroy");
        metadata.addProperty("blueprintContainer", (Metadata)CmNamespaceHandler.createRef(context, "blueprintContainer"));
        metadata.addProperty("configAdmin", (Metadata)this.createConfigurationAdminRef(context));
        metadata.addProperty("persistentId", (Metadata)CmNamespaceHandler.createValue(context, element.getAttribute(PERSISTENT_ID_ATTRIBUTE)));
        String prefix = element.hasAttribute(PLACEHOLDER_PREFIX_ATTRIBUTE) ? element.getAttribute(PLACEHOLDER_PREFIX_ATTRIBUTE) : "${";
        metadata.addProperty("placeholderPrefix", (Metadata)CmNamespaceHandler.createValue(context, prefix));
        String suffix = element.hasAttribute(PLACEHOLDER_SUFFIX_ATTRIBUTE) ? element.getAttribute(PLACEHOLDER_SUFFIX_ATTRIBUTE) : "}";
        metadata.addProperty("placeholderSuffix", (Metadata)CmNamespaceHandler.createValue(context, suffix));
        String string = defaultsRef = element.hasAttribute(DEFAULTS_REF_ATTRIBUTE) ? element.getAttribute(DEFAULTS_REF_ATTRIBUTE) : null;
        if (defaultsRef != null) {
            metadata.addProperty("defaultProperties", (Metadata)CmNamespaceHandler.createRef(context, defaultsRef));
        }
        if ((ignoreMissingLocations = this.extractIgnoreMissingLocations(element)) != null) {
            metadata.addProperty("ignoreMissingLocations", (Metadata)CmNamespaceHandler.createValue(context, ignoreMissingLocations));
        }
        if ((systemProperties = this.extractSystemPropertiesAttribute(element)) == null) {
            systemProperties = SYSTEM_PROPERTIES_NEVER;
        }
        metadata.addProperty("systemProperties", (Metadata)CmNamespaceHandler.createValue(context, systemProperties));
        String updateStrategy = element.getAttribute(UPDATE_STRATEGY_ATTRIBUTE);
        if (updateStrategy != null) {
            metadata.addProperty("updateStrategy", (Metadata)CmNamespaceHandler.createValue(context, updateStrategy));
        }
        metadata.addProperty("managedObjectManager", (Metadata)CmNamespaceHandler.createRef(context, MANAGED_OBJECT_MANAGER_NAME));
        ArrayList<String> locations = new ArrayList<String>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (CmNamespaceHandler.isCmNamespace(e.getNamespaceURI())) {
                if (!CmNamespaceHandler.nodeNameEquals(e, DEFAULT_PROPERTIES_ELEMENT)) continue;
                if (defaultsRef != null) {
                    throw new ComponentDefinitionException("Only one of defaults-ref attribute or default-properties element is allowed");
                }
                Metadata props = this.parseDefaultProperties(context, metadata, e);
                metadata.addProperty("defaultProperties", props);
                continue;
            }
            if (!CmNamespaceHandler.isExtNamespace(e.getNamespaceURI()) || !CmNamespaceHandler.nodeNameEquals(e, LOCATION_ELEMENT)) continue;
            locations.add(CmNamespaceHandler.getTextValue(e));
        }
        if (!locations.isEmpty()) {
            metadata.addProperty("locations", (Metadata)CmNamespaceHandler.createList(context, locations));
        }
        PlaceholdersUtils.validatePlaceholder((MutableBeanMetadata)metadata, (ComponentDefinitionRegistry)context.getComponentDefinitionRegistry());
        return metadata;
    }

    private String extractSystemPropertiesAttribute(Element element) {
        String systemProperties = null;
        if (element.hasAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_0, SYSTEM_PROPERTIES_ATTRIBUTE)) {
            systemProperties = element.getAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_0, SYSTEM_PROPERTIES_ATTRIBUTE);
        } else if (element.hasAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_1, SYSTEM_PROPERTIES_ATTRIBUTE)) {
            systemProperties = element.getAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_1, SYSTEM_PROPERTIES_ATTRIBUTE);
        } else if (element.hasAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_2, SYSTEM_PROPERTIES_ATTRIBUTE)) {
            systemProperties = element.getAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_2, SYSTEM_PROPERTIES_ATTRIBUTE);
        }
        return systemProperties;
    }

    private String extractIgnoreMissingLocations(Element element) {
        String ignoreMissingLocations = null;
        if (element.hasAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_0, IGNORE_MISSING_LOCATIONS_ATTRIBUTE)) {
            ignoreMissingLocations = element.getAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_0, IGNORE_MISSING_LOCATIONS_ATTRIBUTE);
        } else if (element.hasAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_1, IGNORE_MISSING_LOCATIONS_ATTRIBUTE)) {
            ignoreMissingLocations = element.getAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_1, IGNORE_MISSING_LOCATIONS_ATTRIBUTE);
        } else if (element.hasAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_2, IGNORE_MISSING_LOCATIONS_ATTRIBUTE)) {
            ignoreMissingLocations = element.getAttributeNS(BLUEPRINT_EXT_NAMESPACE_V1_1, IGNORE_MISSING_LOCATIONS_ATTRIBUTE);
        }
        return ignoreMissingLocations;
    }

    private Metadata parseDefaultProperties(ParserContext context, MutableBeanMetadata enclosingComponent, Element element) {
        MutableMapMetadata props = (MutableMapMetadata)context.createMetadata(MutableMapMetadata.class);
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !CmNamespaceHandler.isCmNamespace((e = (Element)node).getNamespaceURI()) || !CmNamespaceHandler.nodeNameEquals(e, PROPERTY_ELEMENT)) continue;
            BeanProperty prop = (BeanProperty)context.parseElement(BeanProperty.class, (ComponentMetadata)enclosingComponent, e);
            props.addEntry((NonNullMetadata)CmNamespaceHandler.createValue(context, prop.getName(), String.class.getName()), prop.getValue());
        }
        return props;
    }

    private ComponentMetadata parseManagedServiceFactory(ParserContext context, Element element) {
        String autoExport;
        String id = this.getId(context, element);
        MutableBeanMetadata factoryMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        this.generateIdIfNeeded(context, (MutableComponentMetadata)factoryMetadata);
        factoryMetadata.addProperty(ID_ATTRIBUTE, (Metadata)CmNamespaceHandler.createValue(context, factoryMetadata.getId()));
        factoryMetadata.setScope("singleton");
        factoryMetadata.setRuntimeClass(CmManagedServiceFactory.class);
        factoryMetadata.setInitMethod("init");
        factoryMetadata.setDestroyMethod("destroy");
        factoryMetadata.addArgument((Metadata)CmNamespaceHandler.createRef(context, "blueprintContainer"), null, 0);
        factoryMetadata.addProperty("factoryPid", (Metadata)CmNamespaceHandler.createValue(context, element.getAttribute(FACTORY_PID_ATTRIBUTE)));
        String string = autoExport = element.hasAttribute(AUTO_EXPORT_ATTRIBUTE) ? element.getAttribute(AUTO_EXPORT_ATTRIBUTE) : "disabled";
        if ("disabled".equals(autoExport)) {
            autoExport = Integer.toString(1);
        } else if ("interfaces".equals(autoExport)) {
            autoExport = Integer.toString(2);
        } else if (AUTO_EXPORT_CLASS_HIERARCHY.equals(autoExport)) {
            autoExport = Integer.toString(3);
        } else if (AUTO_EXPORT_ALL.equals(autoExport)) {
            autoExport = Integer.toString(4);
        } else {
            throw new ComponentDefinitionException("Illegal value (" + autoExport + ") for " + AUTO_EXPORT_ATTRIBUTE + " attribute");
        }
        factoryMetadata.addProperty("autoExport", (Metadata)CmNamespaceHandler.createValue(context, autoExport));
        String ranking = element.hasAttribute(RANKING_ATTRIBUTE) ? element.getAttribute(RANKING_ATTRIBUTE) : RANKING_DEFAULT;
        factoryMetadata.addProperty(RANKING_ATTRIBUTE, (Metadata)CmNamespaceHandler.createValue(context, ranking));
        List<String> interfaces = null;
        if (element.hasAttribute(INTERFACE_ATTRIBUTE)) {
            interfaces = Collections.singletonList(element.getAttribute(INTERFACE_ATTRIBUTE));
            factoryMetadata.addProperty("interfaces", (Metadata)CmNamespaceHandler.createList(context, interfaces));
        }
        ArrayList<Object> listeners = new ArrayList<Object>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (CmNamespaceHandler.isBlueprintNamespace(element2.getNamespaceURI())) {
                if (CmNamespaceHandler.nodeNameEquals(element2, "interfaces")) {
                    if (interfaces != null) {
                        throw new ComponentDefinitionException("Only one of interface attribute or interfaces element must be used");
                    }
                    interfaces = this.parseInterfaceNames(element2);
                    factoryMetadata.addProperty("interfaces", (Metadata)CmNamespaceHandler.createList(context, interfaces));
                    continue;
                }
                if (CmNamespaceHandler.nodeNameEquals(element2, SERVICE_PROPERTIES_ELEMENT)) {
                    MapMetadata map = (MapMetadata)context.parseElement(MapMetadata.class, (ComponentMetadata)factoryMetadata, element2);
                    factoryMetadata.addProperty("serviceProperties", (Metadata)map);
                    NodeList enl = element2.getChildNodes();
                    for (int j = 0; j < enl.getLength(); ++j) {
                        Node enode = enl.item(j);
                        if (!(enode instanceof Element) || !CmNamespaceHandler.isCmNamespace(enode.getNamespaceURI()) || !CmNamespaceHandler.nodeNameEquals(enode, CM_PROPERTIES_ELEMENT)) continue;
                        this.decorateCmProperties(context, (Element)enode, (ComponentMetadata)factoryMetadata);
                    }
                    continue;
                }
                if (!CmNamespaceHandler.nodeNameEquals(element2, REGISTRATION_LISTENER_ELEMENT)) continue;
                listeners.add(context.parseElement(RegistrationListener.class, (ComponentMetadata)factoryMetadata, element2));
                continue;
            }
            if (!CmNamespaceHandler.isCmNamespace(element2.getNamespaceURI()) || !CmNamespaceHandler.nodeNameEquals(element2, MANAGED_COMPONENT_ELEMENT)) continue;
            MutableBeanMetadata managedComponent = (MutableBeanMetadata)context.parseElement(MutableBeanMetadata.class, null, element2);
            this.generateIdIfNeeded(context, (MutableComponentMetadata)managedComponent);
            managedComponent.setScope("prototype");
            String destroyMethod = managedComponent.getDestroyMethod();
            if (destroyMethod != null) {
                factoryMetadata.addProperty("componentDestroyMethod", (Metadata)CmNamespaceHandler.createValue(context, destroyMethod));
                managedComponent.setDestroyMethod(null);
            }
            context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)managedComponent);
            factoryMetadata.addProperty("managedComponentName", (Metadata)CmNamespaceHandler.createIdRef(context, managedComponent.getId()));
        }
        MutableCollectionMetadata listenerCollection = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
        listenerCollection.setCollectionClass(List.class);
        for (RegistrationListener registrationListener : listeners) {
            MutableBeanMetadata bean = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            bean.setRuntimeClass(ServiceListener.class);
            bean.addProperty("listener", (Metadata)registrationListener.getListenerComponent());
            bean.addProperty("registerMethod", (Metadata)CmNamespaceHandler.createValue(context, registrationListener.getRegistrationMethod()));
            bean.addProperty("unregisterMethod", (Metadata)CmNamespaceHandler.createValue(context, registrationListener.getUnregistrationMethod()));
            listenerCollection.addValue((Metadata)bean);
        }
        factoryMetadata.addProperty("listeners", (Metadata)listenerCollection);
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factoryMetadata);
        MutableBeanMetadata mapMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        mapMetadata.setScope("singleton");
        mapMetadata.setId(id);
        mapMetadata.setFactoryComponent((Target)CmNamespaceHandler.createRef(context, factoryMetadata.getId()));
        mapMetadata.setFactoryMethod("getServiceMap");
        return mapMetadata;
    }

    private ComponentMetadata decorateCmProperties(ParserContext context, Element element, ComponentMetadata component) {
        this.generateIdIfNeeded(context, (MutableComponentMetadata)component);
        MutableBeanMetadata metadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        metadata.setProcessor(true);
        metadata.setId(this.getId(context, element));
        metadata.setRuntimeClass(CmProperties.class);
        String persistentId = element.getAttribute(PERSISTENT_ID_ATTRIBUTE);
        if (persistentId.length() > 0) {
            metadata.setInitMethod("init");
            metadata.setDestroyMethod("destroy");
        }
        metadata.addProperty("blueprintContainer", (Metadata)CmNamespaceHandler.createRef(context, "blueprintContainer"));
        metadata.addProperty("configAdmin", (Metadata)this.createConfigurationAdminRef(context));
        metadata.addProperty("managedObjectManager", (Metadata)CmNamespaceHandler.createRef(context, MANAGED_OBJECT_MANAGER_NAME));
        metadata.addProperty("persistentId", (Metadata)CmNamespaceHandler.createValue(context, persistentId));
        if (element.hasAttribute(UPDATE_ATTRIBUTE)) {
            metadata.addProperty(UPDATE_ATTRIBUTE, (Metadata)CmNamespaceHandler.createValue(context, element.getAttribute(UPDATE_ATTRIBUTE)));
        }
        metadata.addProperty("serviceId", (Metadata)CmNamespaceHandler.createIdRef(context, component.getId()));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)metadata);
        return component;
    }

    private ComponentMetadata decorateManagedProperties(ParserContext context, Element element, ComponentMetadata component) {
        if (!(component instanceof MutableBeanMetadata)) {
            throw new ComponentDefinitionException("Element managed-properties must be used inside a <bp:bean> element");
        }
        this.generateIdIfNeeded(context, (MutableComponentMetadata)((MutableBeanMetadata)component));
        MutableBeanMetadata metadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        metadata.setProcessor(true);
        metadata.setId(this.getId(context, element));
        metadata.setRuntimeClass(CmManagedProperties.class);
        String persistentId = element.getAttribute(PERSISTENT_ID_ATTRIBUTE);
        if (persistentId.length() > 0) {
            metadata.setInitMethod("init");
            metadata.setDestroyMethod("destroy");
        }
        metadata.addProperty("blueprintContainer", (Metadata)CmNamespaceHandler.createRef(context, "blueprintContainer"));
        metadata.addProperty("configAdmin", (Metadata)this.createConfigurationAdminRef(context));
        metadata.addProperty("managedObjectManager", (Metadata)CmNamespaceHandler.createRef(context, MANAGED_OBJECT_MANAGER_NAME));
        metadata.addProperty("persistentId", (Metadata)CmNamespaceHandler.createValue(context, persistentId));
        String updateStrategy = element.getAttribute(UPDATE_STRATEGY_ATTRIBUTE);
        if (updateStrategy != null) {
            metadata.addProperty("updateStrategy", (Metadata)CmNamespaceHandler.createValue(context, updateStrategy));
        }
        if (element.hasAttribute(UPDATE_METHOD_ATTRIBUTE)) {
            metadata.addProperty("updateMethod", (Metadata)CmNamespaceHandler.createValue(context, element.getAttribute(UPDATE_METHOD_ATTRIBUTE)));
        } else if ("component-managed".equals(updateStrategy)) {
            throw new ComponentDefinitionException("update-method attribute must be set when update-strategy is set to 'component-managed'");
        }
        metadata.addProperty("beanName", (Metadata)CmNamespaceHandler.createIdRef(context, component.getId()));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)metadata);
        return component;
    }

    private void registerManagedObjectManager(ParserContext context, ComponentDefinitionRegistry registry) {
        if (registry.getComponentDefinition(MANAGED_OBJECT_MANAGER_NAME) == null) {
            MutableBeanMetadata beanMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            beanMetadata.setScope("singleton");
            beanMetadata.setId(MANAGED_OBJECT_MANAGER_NAME);
            beanMetadata.setRuntimeClass(ManagedObjectManager.class);
            registry.registerComponentDefinition((ComponentMetadata)beanMetadata);
        }
    }

    private MutableReferenceMetadata createConfigurationAdminRef(ParserContext context) {
        return this.createServiceRef(context, ConfigurationAdmin.class, null);
    }

    private static ValueMetadata createValue(ParserContext context, String value) {
        return CmNamespaceHandler.createValue(context, value, null);
    }

    private static ValueMetadata createValue(ParserContext context, String value, String type) {
        MutableValueMetadata m = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        m.setStringValue(value);
        m.setType(type);
        return m;
    }

    private static RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata m = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    private MutableReferenceMetadata createServiceRef(ParserContext context, Class<?> cls, String filter) {
        MutableReferenceMetadata m = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
        m.setRuntimeInterface(cls);
        m.setInterface(cls.getName());
        m.setActivation(1);
        m.setAvailability(1);
        if (filter != null) {
            m.setFilter(filter);
        }
        return m;
    }

    private static IdRefMetadata createIdRef(ParserContext context, String value) {
        MutableIdRefMetadata m = (MutableIdRefMetadata)context.createMetadata(MutableIdRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    private static CollectionMetadata createList(ParserContext context, List<String> list) {
        MutableCollectionMetadata m = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
        m.setCollectionClass(List.class);
        m.setValueType(String.class.getName());
        for (String v : list) {
            m.addValue((Metadata)CmNamespaceHandler.createValue(context, v, String.class.getName()));
        }
        return m;
    }

    private static String getTextValue(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    public static boolean isBlueprintNamespace(String ns) {
        return BLUEPRINT_NAMESPACE.equals(ns);
    }

    public static boolean isCmNamespace(String uri) {
        return BLUEPRINT_CM_NAMESPACE_1_0.equals(uri) || BLUEPRINT_CM_NAMESPACE_1_1.equals(uri) || BLUEPRINT_CM_NAMESPACE_1_2.equals(uri) || BLUEPRINT_CM_NAMESPACE_1_3.equals(uri);
    }

    public static boolean isExtNamespace(String uri) {
        return BLUEPRINT_EXT_NAMESPACE_V1_0.equals(uri) || BLUEPRINT_EXT_NAMESPACE_V1_1.equals(uri) || BLUEPRINT_EXT_NAMESPACE_V1_2.equals(uri);
    }

    public String getId(ParserContext context, Element element) {
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            return element.getAttribute(ID_ATTRIBUTE);
        }
        return this.generateId(context);
    }

    public void generateIdIfNeeded(ParserContext context, MutableComponentMetadata metadata) {
        if (metadata.getId() == null) {
            metadata.setId(this.generateId(context));
        }
    }

    private String generateId(ParserContext context) {
        String id;
        do {
            id = ".cm-" + ++this.idCounter;
        } while (context.getComponentDefinitionRegistry().containsComponentDefinition(id));
        return id;
    }

    public List<String> parseInterfaceNames(Element element) {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (CmNamespaceHandler.nodeNameEquals(e, VALUE_ELEMENT)) {
                String v = CmNamespaceHandler.getTextValue(e).trim();
                if (interfaceNames.contains(v)) {
                    throw new ComponentDefinitionException("The element interfaces should not contain the same interface twice");
                }
                interfaceNames.add(CmNamespaceHandler.getTextValue(e));
                continue;
            }
            throw new ComponentDefinitionException("Unsupported element " + e.getNodeName() + " inside an " + "interfaces" + " element");
        }
        return interfaceNames;
    }
}

