/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.util.List;
import java.util.logging.Level;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ProcessesXmlStopProcessEnginesStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        EnsureUtil.ensureNotNull("Cannot find process application with name " + processApplication.getName(), "deployedProcessApplication", (Object)deployedProcessApplication);
        List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
        for (ProcessesXml processesXml : processesXmls) {
            this.stopProcessEngines(processesXml.getProcessEngines(), operationContext);
        }
    }

    protected void stopProcessEngines(List<ProcessEngineXml> processEngine, DeploymentOperation operationContext) {
        for (ProcessEngineXml parsedProcessEngine : processEngine) {
            this.stopProcessEngine(parsedProcessEngine.getName(), operationContext);
        }
    }

    protected void stopProcessEngine(String processEngineName, DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        try {
            serviceContainer.stopService(ServiceTypes.PROCESS_ENGINE, processEngineName);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Could not stop managed process engine: " + e.getMessage(), e);
        }
    }
}

