/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.util.Set;
import java.util.logging.Level;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;

public class StopProcessEnginesStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        Set<String> serviceNames = serviceContainer.getServiceNames(ServiceTypes.PROCESS_ENGINE);
        for (String serviceName : serviceNames) {
            this.stopProcessEngine(serviceName, serviceContainer);
        }
    }

    private void stopProcessEngine(String serviceName, PlatformServiceContainer serviceContainer) {
        try {
            serviceContainer.stopService(serviceName);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.FINE, "Could not stop managed process engine " + serviceName.toString(), e);
        }
    }
}

