/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageOrTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.util.ActivityBehaviorUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class StageActivityBehavior
extends StageOrTaskActivityBehavior
implements CompositeActivityBehavior {
    @Override
    protected void performStart(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        List<CmmnActivity> childActivities = activity.getActivities();
        if (childActivities != null && !childActivities.isEmpty()) {
            List<CmmnExecution> children = execution.createChildExecutions(childActivities);
            execution.createSentryParts();
            execution.triggerChildExecutionsLifecycle(children);
        } else {
            execution.complete();
        }
    }

    @Override
    public void onReactivation(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isActive()) {
            String message = "Case execution '" + id + "' is already active.";
            throw this.createIllegalStateTransitionException("reactivate", message, execution);
        }
        if (execution.isCaseInstanceExecution()) {
            if (execution.isClosed()) {
                String message = "it is not possible to reactivate the closed case instance '" + id + "'.";
                throw this.createIllegalStateTransitionException("reactivate", message, execution);
            }
        } else {
            this.ensureTransitionAllowed(execution, CaseExecutionState.FAILED, CaseExecutionState.ACTIVE, "reactivate");
        }
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
        CaseExecutionState previousState;
        if (execution.isCaseInstanceExecution() && CaseExecutionState.SUSPENDED.equals(previousState = execution.getPreviousState())) {
            this.resumed(execution);
        }
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.canComplete(execution, false, true);
        this.completing(execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.canComplete(execution, true, true);
        this.completing(execution);
    }

    protected boolean canComplete(CmmnActivityExecution execution, boolean manualCompletion, boolean throwException) {
        String id = execution.getId();
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children == null || children.isEmpty()) {
            return true;
        }
        for (CmmnExecution cmmnExecution : children) {
            if (!cmmnExecution.isActive()) continue;
            if (throwException) {
                String string = "At least one child case execution of case execution '" + id + "' is active.";
                throw this.createIllegalStateTransitionException("complete", string, execution);
            }
            return false;
        }
        boolean autoComplete = this.evaluateAutoComplete(execution);
        if (autoComplete || manualCompletion) {
            for (CmmnExecution cmmnExecution : children) {
                if (!cmmnExecution.isRequired() || cmmnExecution.isDisabled() || cmmnExecution.isCompleted() || cmmnExecution.isTerminated()) continue;
                if (throwException) {
                    String message = "At least one required child case execution of case execution '" + id + "'is '" + cmmnExecution.getCurrentState() + "'.";
                    throw this.createIllegalStateTransitionException("complete", message, execution);
                }
                return false;
            }
        } else {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isDisabled() || cmmnExecution.isCompleted() || cmmnExecution.isTerminated()) continue;
                if (throwException) {
                    String message = "At least one required child case execution of case execution '" + id + "' is {available|enabled|suspended}.";
                    throw this.createIllegalStateTransitionException("complete", message, execution);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean evaluateAutoComplete(CmmnActivityExecution execution) {
        CmmnActivity activity = this.getActivity(execution);
        Object autoCompleteProperty = activity.getProperty("autoComplete");
        if (autoCompleteProperty != null) {
            String message = "Property autoComplete expression returns non-Boolean: " + autoCompleteProperty + " (" + autoCompleteProperty.getClass().getName() + ")";
            EnsureUtil.ensureInstanceOf(message, "autoComplete", autoCompleteProperty, Boolean.class);
            return (Boolean)autoCompleteProperty;
        }
        return false;
    }

    protected boolean isAbleToTerminate(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isTerminated() || cmmnExecution.isCompleted()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void performTerminate(CmmnActivityExecution execution) {
        if (!this.isAbleToTerminate(execution)) {
            this.terminateChildren(execution);
        } else {
            super.performTerminate(execution);
        }
    }

    @Override
    protected void performExit(CmmnActivityExecution execution) {
        if (!this.isAbleToTerminate(execution)) {
            this.terminateChildren(execution);
        } else {
            super.performExit(execution);
        }
    }

    protected void terminateChildren(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        for (CmmnExecution cmmnExecution : children) {
            CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(cmmnExecution);
            if (cmmnExecution.isTerminated() || cmmnExecution.isCompleted()) continue;
            if (behavior instanceof StageOrTaskActivityBehavior) {
                cmmnExecution.exit();
                continue;
            }
            cmmnExecution.parentTerminate();
        }
    }

    @Override
    protected void performSuspension(CmmnActivityExecution execution) {
        if (!this.isAbleToSuspend(execution)) {
            this.suspendChildren(execution);
        } else {
            super.performSuspension(execution);
        }
    }

    @Override
    protected void performParentSuspension(CmmnActivityExecution execution) {
        if (!this.isAbleToSuspend(execution)) {
            this.suspendChildren(execution);
        } else {
            super.performParentSuspension(execution);
        }
    }

    protected void suspendChildren(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(cmmnExecution);
                if (cmmnExecution.isTerminated() || cmmnExecution.isSuspended()) continue;
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.parentSuspend();
                    continue;
                }
                cmmnExecution.suspend();
            }
        }
    }

    protected boolean isAbleToSuspend(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isSuspended()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
        if (execution.isAvailable()) {
            this.created(execution);
        } else if (execution.isActive()) {
            this.resumeChildren(execution);
        }
    }

    protected void resumeChildren(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(cmmnExecution);
                if (cmmnExecution.isTerminated()) continue;
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.parentResume();
                    continue;
                }
                cmmnExecution.resume();
            }
        }
    }

    @Override
    protected boolean isAtLeastOneEntryCriteriaSatisfied(CmmnActivityExecution execution) {
        if (!execution.isCaseInstanceExecution()) {
            return super.isAtLeastOneEntryCriteriaSatisfied(execution);
        }
        return false;
    }

    @Override
    public void fireExitCriteria(CmmnActivityExecution execution) {
        if (!execution.isCaseInstanceExecution()) {
            execution.exit();
        } else {
            execution.terminate();
        }
    }

    @Override
    public void fireEntryCriteria(CmmnActivityExecution execution) {
        if (!execution.isCaseInstanceExecution()) {
            super.fireEntryCriteria(execution);
            return;
        }
        throw new CaseIllegalStateTransitionException("Cannot trigger case instance '" + execution.getId() + "': entry criteria are not allowed for a case instance.");
    }

    @Override
    public void handleChildCompletion(CmmnActivityExecution execution, CmmnActivityExecution child) {
        this.fireForceUpdate(execution);
        if (execution.isActive()) {
            this.checkAndCompleteCaseExecution(execution);
        }
    }

    @Override
    public void handleChildDisabled(CmmnActivityExecution execution, CmmnActivityExecution child) {
        this.fireForceUpdate(execution);
        if (execution.isActive()) {
            this.checkAndCompleteCaseExecution(execution);
        }
    }

    @Override
    public void handleChildSuspension(CmmnActivityExecution execution, CmmnActivityExecution child) {
        if (execution.isSuspending() && this.isAbleToSuspend(execution)) {
            String id = execution.getId();
            CaseExecutionState currentState = execution.getCurrentState();
            if (CaseExecutionState.SUSPENDING_ON_SUSPENSION.equals(currentState)) {
                execution.performSuspension();
            } else if (CaseExecutionState.SUSPENDING_ON_PARENT_SUSPENSION.equals(currentState)) {
                execution.performParentSuspension();
            } else {
                throw new PvmException("Could not suspend case execution '" + id + "': excpected {terminatingOnTermination|terminatingOnExit}, but was " + currentState + ".");
            }
        }
    }

    @Override
    public void handleChildTermination(CmmnActivityExecution execution, CmmnActivityExecution child) {
        this.fireForceUpdate(execution);
        if (execution.isActive()) {
            this.checkAndCompleteCaseExecution(execution);
        } else if (execution.isTerminating() && this.isAbleToTerminate(execution)) {
            String id = execution.getId();
            CaseExecutionState currentState = execution.getCurrentState();
            if (CaseExecutionState.TERMINATING_ON_TERMINATION.equals(currentState)) {
                execution.performTerminate();
            } else if (CaseExecutionState.TERMINATING_ON_EXIT.equals(currentState)) {
                execution.performExit();
            } else {
                if (CaseExecutionState.TERMINATING_ON_PARENT_TERMINATION.equals(currentState)) {
                    String message = "It is not possible to parentTerminate case execution '" + id + "' which associated with a " + this.getTypeName() + ".";
                    throw this.createIllegalStateTransitionException("parentTerminate", message, execution);
                }
                throw new PvmException("Could not terminate case execution '" + id + "': excpected {terminatingOnTermination|terminatingOnExit}, but was " + currentState + ".");
            }
        }
    }

    protected void checkAndCompleteCaseExecution(CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = this.getActivity(execution);
        Object property = activity.getProperty("autoComplete");
        boolean autoComplete = false;
        if (property != null) {
            EnsureUtil.ensureInstanceOf("Cannot evaluate autoComplete property for case execution '" + id + "': autoComplete property must evaluate to boolean.", "autoComplete", property, Boolean.class);
            autoComplete = (Boolean)property;
        }
        if (this.canComplete(execution, autoComplete, false)) {
            execution.complete();
        }
    }

    protected void fireForceUpdate(CmmnActivityExecution execution) {
        if (execution instanceof CaseExecutionEntity) {
            CaseExecutionEntity entity = (CaseExecutionEntity)execution;
            entity.forceUpdate();
        }
    }

    @Override
    protected String getTypeName() {
        return "stage";
    }
}

