/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.FormType;
import org.camunda.bpm.engine.impl.el.StartProcessVariableScope;
import org.camunda.bpm.engine.impl.form.FormPropertyImpl;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.variable.VariableMap;

public class FormPropertyHandler {
    protected String id;
    protected String name;
    protected AbstractFormFieldType type;
    protected boolean isReadable;
    protected boolean isWritable;
    protected boolean isRequired;
    protected String variableName;
    protected Expression variableExpression;
    protected Expression defaultExpression;

    public FormProperty createFormProperty(ExecutionEntity execution) {
        FormPropertyImpl formProperty = new FormPropertyImpl(this);
        Object modelValue = null;
        if (execution != null) {
            if (this.variableName != null || this.variableExpression == null) {
                String varName;
                String string = varName = this.variableName != null ? this.variableName : this.id;
                if (execution.hasVariable(varName)) {
                    modelValue = execution.getVariable(varName);
                } else if (this.defaultExpression != null) {
                    modelValue = this.defaultExpression.getValue(execution);
                }
            } else {
                modelValue = this.variableExpression.getValue(execution);
            }
        } else if (this.defaultExpression != null) {
            modelValue = this.defaultExpression.getValue(StartProcessVariableScope.getSharedInstance());
        }
        if (modelValue instanceof String) {
            formProperty.setValue((String)modelValue);
        } else if (this.type != null) {
            String formValue = this.type.convertModelValueToFormValue(modelValue);
            formProperty.setValue(formValue);
        } else if (modelValue != null) {
            formProperty.setValue(modelValue.toString());
        }
        return formProperty;
    }

    public void submitFormProperty(VariableScope variableScope, VariableMap variables) {
        if (!this.isWritable && variables.containsKey(this.id)) {
            throw new ProcessEngineException("form property '" + this.id + "' is not writable");
        }
        if (this.isRequired && !variables.containsKey(this.id) && this.defaultExpression == null) {
            throw new ProcessEngineException("form property '" + this.id + "' is required");
        }
        Object modelValue = null;
        if (variables.containsKey(this.id)) {
            Object propertyValue = variables.remove(this.id);
            modelValue = this.type != null ? this.type.convertFormValueToModelValue(propertyValue) : (Object)propertyValue;
        } else if (this.defaultExpression != null) {
            Object expressionValue = this.defaultExpression.getValue(variableScope);
            if (this.type != null && expressionValue != null) {
                modelValue = this.type.convertFormValueToModelValue(expressionValue.toString());
            } else if (expressionValue != null) {
                modelValue = expressionValue.toString();
            } else if (this.isRequired) {
                throw new ProcessEngineException("form property '" + this.id + "' is required");
            }
        }
        if (modelValue != null) {
            if (this.variableName != null) {
                variableScope.setVariable(this.variableName, modelValue);
            } else if (this.variableExpression != null) {
                this.variableExpression.setValue(modelValue, variableScope);
            } else {
                variableScope.setVariable(this.id, modelValue);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FormType getType() {
        return this.type;
    }

    public void setType(AbstractFormFieldType type) {
        this.type = type;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public void setReadable(boolean isReadable) {
        this.isReadable = isReadable;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public Expression getVariableExpression() {
        return this.variableExpression;
    }

    public void setVariableExpression(Expression variableExpression) {
        this.variableExpression = variableExpression;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }
}

