/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.aries.blueprint.container.AbstractServiceReferenceRecipe;
import org.apache.aries.blueprint.container.BeanRecipe;
import org.apache.aries.blueprint.container.DependencyGraph;
import org.apache.aries.blueprint.container.ReferenceListRecipe;
import org.apache.aries.blueprint.container.ServiceRecipe;
import org.apache.aries.blueprint.di.CircularDependencyException;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.ExecutionContext;
import org.apache.aries.blueprint.di.IdRefRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.di.RefRecipe;
import org.apache.aries.blueprint.di.Repository;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.container.ReifiedType;

public class BlueprintRepository
implements Repository,
ExecutionContext {
    private final ExtendedBlueprintContainer blueprintContainer;
    private final Map<String, Recipe> recipes = new ConcurrentHashMap<String, Recipe>();
    private final ConcurrentMap<String, Future<Object>> instances = new ConcurrentHashMap<String, Future<Object>>();
    private final List<String> creationOrder = new CopyOnWriteArrayList<String>();
    private final ThreadLocal<Map<String, Object>> partialObjects = new ThreadLocal();
    private final ThreadLocal<LinkedList<Recipe>> stack = new ThreadLocal();

    public BlueprintRepository(ExtendedBlueprintContainer container) {
        this.blueprintContainer = container;
    }

    @Override
    public Object getInstance(String name) {
        Future future = (Future)this.instances.get(name);
        if (future != null && future.isDone()) {
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            catch (ExecutionException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Recipe getRecipe(String name) {
        return this.recipes.get(name);
    }

    @Override
    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.recipes.keySet());
        names.addAll(this.instances.keySet());
        return names;
    }

    @Override
    public void putRecipe(String name, Recipe recipe) {
        if (this.instances.containsKey(name)) {
            throw new ComponentDefinitionException("Name " + name + " is already registered to instance " + this.getInstance(name));
        }
        this.recipes.put(name, recipe);
    }

    @Override
    public void removeRecipe(String name) {
        if (this.instances.containsKey(name)) {
            throw new ComponentDefinitionException("Name " + name + " is already instanciated as " + this.getInstance(name) + " and cannot be removed.");
        }
        this.recipes.remove(name);
    }

    private Object convert(String name, Object instance) throws ComponentDefinitionException {
        try {
            return this.convert(instance, new ReifiedType(Object.class));
        }
        catch (Exception e) {
            throw new ComponentDefinitionException("Unable to convert instance " + name, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object create(String name) throws ComponentDefinitionException {
        ExecutionContext oldContext = ExecutionContext.Holder.setContext(this);
        try {
            Object instance = this.createInstance(name);
            Object object = this.convert(name, instance);
            return object;
        }
        finally {
            ExecutionContext.Holder.setContext(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object create(String name, Collection<Class<?>> proxyInterfaces) throws ComponentDefinitionException {
        ExecutionContext oldContext = ExecutionContext.Holder.setContext(this);
        try {
            Object instance = this.createInstance(name);
            if (instance instanceof BeanRecipe.UnwrapperedBeanHolder) {
                instance = BeanRecipe.wrap((BeanRecipe.UnwrapperedBeanHolder)instance, proxyInterfaces);
            }
            Object object = this.convert(name, instance);
            return object;
        }
        finally {
            ExecutionContext.Holder.setContext(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> createAll(Collection<String> names, Collection<Class<?>> proxyInterfaces) throws ComponentDefinitionException {
        ExecutionContext oldContext = ExecutionContext.Holder.setContext(this);
        try {
            Map<String, Object> instances = this.createInstances(names);
            for (String name : instances.keySet()) {
                Object obj = instances.get(name);
                if (obj instanceof BeanRecipe.UnwrapperedBeanHolder) {
                    obj = BeanRecipe.wrap((BeanRecipe.UnwrapperedBeanHolder)obj, proxyInterfaces);
                }
                instances.put(name, this.convert(name, obj));
            }
            Map<String, Object> map = instances;
            return map;
        }
        finally {
            ExecutionContext.Holder.setContext(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAll(Collection<String> names) throws ComponentDefinitionException {
        ExecutionContext oldContext = ExecutionContext.Holder.setContext(this);
        try {
            this.createInstances(names);
            return;
        }
        finally {
            ExecutionContext.Holder.setContext(oldContext);
        }
    }

    @Override
    public <T> List<T> getAllRecipes(Class<T> clazz, String ... names) {
        ArrayList<T> recipes = new ArrayList<T>();
        for (Recipe r : this.getAllRecipes(names)) {
            if (!clazz.isInstance(r)) continue;
            recipes.add(clazz.cast(r));
        }
        return recipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Recipe> getAllRecipes(String ... names) {
        ExecutionContext oldContext = ExecutionContext.Holder.setContext(this);
        try {
            HashSet<Recipe> allRecipes = new HashSet<Recipe>();
            Set<String> topLevel = names != null && names.length > 0 ? Arrays.asList(names) : this.recipes.keySet();
            for (String name : topLevel) {
                this.internalGetAllRecipes(allRecipes, this.getRecipe(name));
            }
            HashSet<Recipe> hashSet = allRecipes;
            return hashSet;
        }
        finally {
            ExecutionContext.Holder.setContext(oldContext);
        }
    }

    private void internalGetAllRecipes(Set<Recipe> allRecipes, Recipe r) {
        if (r != null && allRecipes.add(r)) {
            for (Recipe c : r.getDependencies()) {
                this.internalGetAllRecipes(allRecipes, c);
            }
        }
    }

    private Object createInstance(String name) {
        Map<String, Object> instances;
        Object instance = this.getInstance(name);
        if (instance == null && (instance = (instances = this.createInstances(Arrays.asList(name))).get(name)) == null) {
            throw new NoSuchComponentException(name);
        }
        return instance;
    }

    private Map<String, Object> createInstances(Collection<String> names) {
        DependencyGraph graph = new DependencyGraph(this);
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Recipe> entry : graph.getSortedRecipes(names).entrySet()) {
            objects.put(entry.getKey(), entry.getValue().create());
        }
        return objects;
    }

    public void validate() {
        for (Recipe recipe : this.getAllRecipes(new String[0])) {
            String ref = null;
            if (recipe instanceof RefRecipe) {
                ref = ((RefRecipe)recipe).getIdRef();
            } else if (recipe instanceof IdRefRecipe) {
                ref = ((IdRefRecipe)recipe).getIdRef();
            }
            if (ref != null && this.getRecipe(ref) == null) {
                throw new ComponentDefinitionException("Unresolved ref/idref to component: " + ref);
            }
            if (recipe instanceof ServiceRecipe) {
                Recipe r = ((ServiceRecipe)recipe).getServiceRecipe();
                if (r instanceof RefRecipe) {
                    r = this.getRecipe(((RefRecipe)r).getIdRef());
                }
                if (r instanceof ServiceRecipe) {
                    throw new ComponentDefinitionException("The target for a <service> element must not be <service> element");
                }
                if (r instanceof ReferenceListRecipe) {
                    throw new ComponentDefinitionException("The target for a <service> element must not be <reference-list> element");
                }
                CollectionRecipe listeners = ((ServiceRecipe)recipe).getListenersRecipe();
                for (Recipe lr : listeners.getDependencies()) {
                    for (Recipe l : lr.getDependencies()) {
                        if (l instanceof RefRecipe) {
                            l = this.getRecipe(((RefRecipe)l).getIdRef());
                        }
                        if (l instanceof ServiceRecipe) {
                            throw new ComponentDefinitionException("The target for a <registration-listener> element must not be <service> element");
                        }
                        if (!(l instanceof ReferenceListRecipe)) continue;
                        throw new ComponentDefinitionException("The target for a <registration-listener> element must not be <reference-list> element");
                    }
                }
            }
            if (!(recipe instanceof AbstractServiceReferenceRecipe)) continue;
            CollectionRecipe listeners = ((AbstractServiceReferenceRecipe)recipe).getListenersRecipe();
            for (Recipe lr : listeners.getDependencies()) {
                for (Recipe l : lr.getDependencies()) {
                    if (l instanceof RefRecipe) {
                        l = this.getRecipe(((RefRecipe)l).getIdRef());
                    }
                    if (l instanceof ServiceRecipe) {
                        throw new ComponentDefinitionException("The target for a <reference-listener> element must not be <service> element");
                    }
                    if (!(l instanceof ReferenceListRecipe)) continue;
                    throw new ComponentDefinitionException("The target for a <reference-listener> element must not be <reference-list> element");
                }
            }
        }
    }

    @Override
    public void destroy() {
        ArrayList<String> order = new ArrayList<String>(this.creationOrder);
        Collections.reverse(order);
        for (String name : order) {
            Recipe recipe = this.recipes.get(name);
            if (recipe == null) continue;
            recipe.destroy(this.getInstance(name));
        }
        this.instances.clear();
        this.creationOrder.clear();
    }

    @Override
    public void push(Recipe recipe) {
        LinkedList<Recipe> list = this.stack.get();
        if (list != null && list.contains(recipe)) {
            ArrayList<Recipe> circularity = new ArrayList<Recipe>(list.subList(list.indexOf(recipe), list.size()));
            Iterator iterator = circularity.iterator();
            while (iterator.hasNext()) {
                Recipe item = (Recipe)iterator.next();
                if (item == recipe || item.getName() != null) continue;
                iterator.remove();
            }
            circularity.add(recipe);
            throw new CircularDependencyException(circularity);
        }
        if (list == null) {
            list = new LinkedList();
            this.stack.set(list);
        }
        list.add(recipe);
    }

    @Override
    public Recipe pop() {
        LinkedList<Recipe> list = this.stack.get();
        return list.removeLast();
    }

    @Override
    public boolean containsObject(String name) {
        return this.instances.containsKey(name) || this.getRecipe(name) != null;
    }

    @Override
    public Object getObject(String name) {
        Future future = (Future)this.instances.get(name);
        Recipe result = null;
        if (future != null && future.isDone()) {
            try {
                result = future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                result = this.getRecipe(name);
            }
            catch (ExecutionException e) {
                result = this.getRecipe(name);
            }
        } else {
            result = this.getRecipe(name);
        }
        return result;
    }

    @Override
    public Future<Object> addFullObject(String name, Future<Object> object) {
        return this.instances.putIfAbsent(name, object);
    }

    @Override
    public void addPartialObject(String name, Object object) {
        if (this.partialObjects.get() == null) {
            this.partialObjects.set(new HashMap());
        }
        this.partialObjects.get().put(name, object);
    }

    @Override
    public Object getPartialObject(String name) {
        return this.partialObjects.get() != null ? this.partialObjects.get().get(name) : null;
    }

    @Override
    public void removePartialObject(String name) {
        this.creationOrder.add(name);
        if (this.partialObjects.get() != null) {
            this.partialObjects.get().remove(name);
        }
    }

    @Override
    public Object convert(Object value, ReifiedType type) throws Exception {
        return this.blueprintContainer.getConverter().convert(value, type);
    }

    @Override
    public boolean canConvert(Object value, ReifiedType type) {
        return this.blueprintContainer.getConverter().canConvert(value, type);
    }

    @Override
    public Class loadClass(String typeName) throws ClassNotFoundException {
        return this.blueprintContainer.loadClass(typeName);
    }
}

