/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.boot.principal;

import java.security.Principal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;

public enum RolePolicy {
    PREFIXED_ROLES("prefix"){

        @Override
        public void handleRoles(Subject subject, Set<Principal> principals, String discriminator) {
            for (Principal p : principals) {
                if (p instanceof RolePrincipal) {
                    RolePrincipal rolePrincipal = new RolePrincipal(discriminator + p.getName());
                    subject.getPrincipals().add(rolePrincipal);
                    continue;
                }
                subject.getPrincipals().add(p);
            }
        }
    };

    private String value;
    private static final Map<String, RolePolicy> policies;

    private RolePolicy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static RolePolicy getPolicy(String code) {
        return policies.get(code);
    }

    public abstract void handleRoles(Subject var1, Set<Principal> var2, String var3);

    static {
        policies = new HashMap<String, RolePolicy>();
        for (RolePolicy s : EnumSet.allOf(RolePolicy.class)) {
            policies.put(s.getValue(), s);
        }
    }
}

