/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ClientConfig {
    private static final String ROLE_DELIMITER = ",";
    private String host;
    private int port;
    private String user;
    private String password;
    private int level;
    private int retryAttempts;
    private int retryDelay;
    private boolean batch;
    private String file = null;
    private String keyFile = null;
    private String command;

    public ClientConfig(String[] args) throws IOException {
        Properties shellCfg = ClientConfig.loadProps(new File(System.getProperty("karaf.etc"), "org.apache.karaf.shell.cfg"));
        this.host = shellCfg.getProperty("sshHost", "localhost");
        this.port = Integer.parseInt(shellCfg.getProperty("sshPort", "8101"));
        this.level = 1;
        this.retryAttempts = 0;
        this.retryDelay = 2;
        this.batch = false;
        this.file = null;
        this.user = null;
        this.password = null;
        StringBuilder commandBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the port");
                        System.exit(1);
                        continue;
                    }
                    this.port = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the host");
                        System.exit(1);
                        continue;
                    }
                    this.host = args[i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the user");
                        System.exit(1);
                        continue;
                    }
                    this.user = args[i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++this.level;
                    continue;
                }
                if (args[i].equals("-r")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the attempts");
                        System.exit(1);
                        continue;
                    }
                    this.retryAttempts = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the delay in seconds");
                        System.exit(1);
                        continue;
                    }
                    this.retryDelay = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals("-b")) {
                    this.batch = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the commands file");
                        System.exit(1);
                        continue;
                    }
                    this.file = args[i];
                    continue;
                }
                if (args[i].equals("-k")) {
                    if (args.length <= ++i) {
                        System.err.println("miss the key file");
                        System.exit(1);
                        continue;
                    }
                    this.keyFile = args[i];
                    continue;
                }
                if (args[i].equals("--help")) {
                    ClientConfig.showHelp();
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            commandBuilder.append(args[i]);
            commandBuilder.append(' ');
        }
        this.command = commandBuilder.toString();
        Properties usersCfg = ClientConfig.loadProps(new File(System.getProperty("karaf.etc") + "/users.properties"));
        if (!usersCfg.isEmpty()) {
            if (this.user == null) {
                this.user = (String)usersCfg.keySet().iterator().next();
            }
            this.password = usersCfg.getProperty(this.user);
            if (this.password != null && this.password.contains(ROLE_DELIMITER)) {
                this.password = this.password.substring(0, this.password.indexOf(ROLE_DELIMITER));
            }
        }
    }

    private static void showHelp() {
        System.out.println("Apache Karaf client");
        System.out.println("  -a [port]     specify the port to connect to");
        System.out.println("  -h [host]     specify the host to connect to");
        System.out.println("  -u [user]     specify the user name");
        System.out.println("  --help        shows this help message");
        System.out.println("  -v            raise verbosity");
        System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
        System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
        System.out.println("  -b            batch mode, specify multiple commands via standard input");
        System.out.println("  -f [file]     read commands from the specified file");
        System.out.println("  -k [keyFile]    specify the private keyFile location when using key login, need have BouncyCastle registered as security provider using this flag");
        System.out.println("  [commands]    commands to run");
        System.out.println("If no commands are specified, the client will be put in an interactive mode");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProps(File file) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            if (is != null) {
                props.load(is);
            }
        }
        catch (Exception e) {
            System.err.println("Could not load properties from: " + file + ", Reason: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public String getFile() {
        return this.file;
    }

    public String getKeyFile() {
        return this.keyFile;
    }
}

