/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.extension.osgi.Extender;
import org.camunda.bpm.extension.osgi.application.ProcessApplicationDeployer;
import org.camunda.bpm.extension.osgi.configadmin.impl.ManagedProcessEngineFactoryImpl;
import org.camunda.bpm.extension.osgi.container.OSGiRuntimeContainerDelegate;
import org.camunda.bpm.extension.osgi.url.bpmn.BpmnDeploymentListener;
import org.camunda.bpm.extension.osgi.url.bpmn.BpmnURLHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = Logger.getLogger(Activator.class.getName());
    private List<Runnable> callbacks = new ArrayList<Runnable>();

    public void start(BundleContext context) throws Exception {
        RuntimeContainerDelegate.INSTANCE.set((RuntimeContainerDelegate)new OSGiRuntimeContainerDelegate(context));
        this.callbacks.add(new Service(context, URLStreamHandlerService.class.getName(), (Object)new BpmnURLHandler(), Activator.props("url.handler.protocol", "bpmn")));
        this.registerBpmnDeploymentListener(context);
        this.registerManagedProcessEngineFactory(context);
        this.callbacks.add(new Tracker(new Extender(context)));
        ServiceTracker paDeployer = new ServiceTracker(context, ProcessApplicationInterface.class.getName(), (ServiceTrackerCustomizer)new ProcessApplicationDeployer());
        this.callbacks.add(new CloseTrackerCallback(paDeployer, true));
    }

    public void stop(BundleContext context) throws Exception {
        for (Runnable r : this.callbacks) {
            r.run();
        }
    }

    private static Dictionary<String, String> props(String ... args) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        for (int i = 0; i < args.length / 2; ++i) {
            ((Dictionary)props).put(args[2 * i], args[2 * i + 1]);
        }
        return props;
    }

    private void registerManagedProcessEngineFactory(BundleContext context) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>(1);
            ((Dictionary)props).put("service.pid", "org.camunda.bpm.extension.osgi.configadmin.ManagedProcessEngineFactory");
            this.callbacks.add(new Service(context, ManagedServiceFactory.class.getName(), (Object)new ManagedProcessEngineFactoryImpl(context), props));
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(Level.WARNING, "ConfigurationAdminService is not available, ManagedProcessEngineFactory won't be created");
        }
    }

    private void registerBpmnDeploymentListener(BundleContext context) {
        try {
            this.callbacks.add(new Service(context, new String[]{ArtifactUrlTransformer.class.getName(), ArtifactListener.class.getName()}, (Object)new BpmnDeploymentListener(), null));
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(Level.WARNING, "FileInstall package is not available, disabling fileinstall support");
        }
    }

    private static class CloseTrackerCallback
    implements Runnable {
        protected ServiceTracker tracker;

        public CloseTrackerCallback(ServiceTracker tracker, boolean isTrackAllServices) {
            this.tracker = tracker;
            tracker.open(isTrackAllServices);
        }

        @Override
        public void run() {
            this.tracker.close();
        }
    }

    private static class Tracker
    implements Runnable {
        private final Extender extender;

        private Tracker(Extender extender) {
            this.extender = extender;
            this.extender.open();
        }

        @Override
        public void run() {
            this.extender.close();
        }
    }

    private static class Service
    implements Runnable {
        private final ServiceRegistration registration;

        public Service(BundleContext context, String clazz, Object service, Dictionary<String, String> props) {
            this.registration = context.registerService(clazz, service, props);
        }

        public Service(BundleContext context, String[] clazz, Object service, Dictionary<String, String> props) {
            this.registration = context.registerService(clazz, service, props);
        }

        @Override
        public void run() {
            this.registration.unregister();
        }
    }
}

