/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.configadmin.impl;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.extension.osgi.blueprint.BundleDelegatingClassLoader;
import org.camunda.bpm.extension.osgi.blueprint.ClassLoaderWrapper;
import org.camunda.bpm.extension.osgi.configadmin.ManagedProcessEngineFactory;
import org.camunda.bpm.extension.osgi.configadmin.impl.ProcessEngineConfigurationFromProperties;
import org.camunda.bpm.extension.osgi.engine.ProcessEngineFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public class ManagedProcessEngineFactoryImpl
implements ManagedProcessEngineFactory {
    private Map<String, ProcessEngine> existingEngines = new ConcurrentHashMap<String, ProcessEngine>();
    private Map<String, ServiceRegistration> existingRegisteredEngines = new ConcurrentHashMap<String, ServiceRegistration>();
    private BundleContext ctx;

    public ManagedProcessEngineFactoryImpl(BundleContext bundleContext) {
        this.ctx = bundleContext;
    }

    public String getName() {
        return "org.camunda.bpm.extension.osgi.configadmin.ManagedProcessEngineFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ProcessEngine engine;
        if (this.existingEngines.containsKey(pid)) {
            this.existingEngines.get(pid).close();
            this.existingEngines.remove(pid);
            this.existingRegisteredEngines.get(pid).unregister();
            this.existingRegisteredEngines.remove(pid);
        }
        if (!this.hasPropertiesConfiguration(properties)) {
            return;
        }
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        Bundle bundle = FrameworkUtil.getBundle(ProcessEngine.class);
        try {
            BundleDelegatingClassLoader cl = new BundleDelegatingClassLoader(bundle);
            Thread.currentThread().setContextClassLoader(new ClassLoaderWrapper(cl, ProcessEngineFactory.class.getClassLoader(), ProcessEngineConfiguration.class.getClassLoader(), previous));
            ProcessEngineConfiguration processEngineConfiguration = this.createProcessEngineConfiguration(properties);
            processEngineConfiguration.setClassLoader((ClassLoader)cl);
            engine = processEngineConfiguration.buildProcessEngine();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
        this.existingEngines.put(pid, engine);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("process-engine-name", engine.getName());
        ServiceRegistration serviceRegistration = this.ctx.registerService(ProcessEngine.class.getName(), (Object)engine, props);
        this.existingRegisteredEngines.put(pid, serviceRegistration);
    }

    private boolean hasPropertiesConfiguration(Dictionary properties) {
        HashMap mapProperties = new HashMap(properties.size());
        for (Object key : Collections.list(properties.keys())) {
            mapProperties.put(key, properties.get(key));
        }
        mapProperties.remove("service.pid");
        mapProperties.remove("service.factoryPid");
        return !mapProperties.isEmpty();
    }

    private ProcessEngineConfiguration createProcessEngineConfiguration(Dictionary properties) throws ConfigurationException {
        ProcessEngineConfigurationFromProperties processEngineConfiguration = new ProcessEngineConfigurationFromProperties();
        processEngineConfiguration.configure(properties);
        return processEngineConfiguration;
    }

    public void deleted(String pid) {
        try {
            ProcessEngine engine = this.existingEngines.get(pid);
            engine.close();
            this.existingEngines.remove(pid);
            this.existingRegisteredEngines.get(pid).unregister();
            this.existingRegisteredEngines.remove(pid);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when trying to delete service with pid " + pid, e);
        }
    }
}

