/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.extension.osgi.util.HeaderParser;
import org.osgi.framework.Bundle;

public final class ProcessDefinitionParser {
    private static final Logger LOGGER = Logger.getLogger(ProcessDefinitionParser.class.getName());

    private ProcessDefinitionParser() {
    }

    public static List<URL> scanForProcesses(Bundle bundle) {
        LOGGER.log(Level.FINE, "Scanning bundle {} for process", bundle.getSymbolicName());
        String processDefHeader = (String)bundle.getHeaders().get("Process-Definitions");
        if (processDefHeader == null) {
            processDefHeader = "OSGI-INF/processes/";
        }
        List<HeaderParser.PathElement> paths = HeaderParser.parseHeader(processDefHeader);
        List<URL> pathList = ProcessDefinitionParser.parsePaths(paths, bundle);
        return pathList;
    }

    private static List<URL> parsePaths(List<HeaderParser.PathElement> paths, Bundle bundle) {
        ArrayList<URL> pathList = new ArrayList<URL>();
        for (HeaderParser.PathElement path : paths) {
            String filePattern;
            String baseName;
            String name = path.getName();
            if (name.endsWith("/")) {
                ProcessDefinitionParser.addEntries(bundle, name, "*.*", pathList);
                continue;
            }
            int pos = name.lastIndexOf(47);
            if (pos < 0) {
                baseName = "/";
                filePattern = name;
            } else {
                baseName = name.substring(0, pos + 1);
                filePattern = name.substring(pos + 1);
            }
            if (ProcessDefinitionParser.hasWildcards(filePattern)) {
                ProcessDefinitionParser.addEntries(bundle, baseName, filePattern, pathList);
                continue;
            }
            pathList.add(bundle.getEntry(name));
        }
        return pathList;
    }

    private static boolean hasWildcards(String path) {
        return path.indexOf("*") >= 0;
    }

    private static void addEntries(Bundle bundle, String path, String filePattern, List<URL> pathList) {
        Enumeration e = bundle.findEntries(path, filePattern, false);
        while (e != null && e.hasMoreElements()) {
            URL u = (URL)e.nextElement();
            pathList.add(u);
        }
    }
}

