/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.DeploymentQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;

public class DeploymentQueryImpl
extends AbstractQuery<DeploymentQuery, Deployment>
implements DeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String name;
    protected String nameLike;
    protected Date deploymentBefore;
    protected Date deploymentAfter;

    public DeploymentQueryImpl() {
    }

    public DeploymentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public DeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DeploymentQueryImpl deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull("Deployment id", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentName(String deploymentName) {
        EnsureUtil.ensureNotNull("deploymentName", (Object)deploymentName);
        this.name = deploymentName;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("deploymentNameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public DeploymentQuery deploymentBefore(Date before) {
        EnsureUtil.ensureNotNull("deploymentBefore", (Object)before);
        this.deploymentBefore = before;
        return this;
    }

    @Override
    public DeploymentQuery deploymentAfter(Date after) {
        EnsureUtil.ensureNotNull("deploymentAfter", (Object)after);
        this.deploymentAfter = after;
        return this;
    }

    @Override
    public DeploymentQuery orderByDeploymentId() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public DeploymentQuery orderByDeploymenTime() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOY_TIME);
    }

    @Override
    public DeploymentQuery orderByDeploymentName() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDeploymentManager().findDeploymentCountByQueryCriteria(this);
    }

    @Override
    public List<Deployment> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDeploymentManager().findDeploymentsByQueryCriteria(this, page);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public Date getDeploymentBefore() {
        return this.deploymentBefore;
    }

    public Date getDeploymentAfter() {
        return this.deploymentAfter;
    }
}

