/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;

public final class SchemaOperationsProcessEngineBuild
implements Command<Object> {
    private static final Logger log = Logger.getLogger(SchemaOperationsProcessEngineBuild.class.getName());

    @Override
    public Object execute(CommandContext commandContext) {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        PersistenceSession persistenceSession = commandContext.getSession(PersistenceSession.class);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                persistenceSession.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaUpdate();
        }
        DbEntityManager entityManager = commandContext.getSession(DbEntityManager.class);
        this.checkHistoryLevel(entityManager);
        this.checkDeploymentLockExists(entityManager);
        return null;
    }

    public static void dbCreateHistoryLevel(DbEntityManager entityManager) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        PropertyEntity property = new PropertyEntity("historyLevel", Integer.toString(configuredHistoryLevel.getId()));
        entityManager.insert(property);
        log.info("Creating historyLevel property in database with value: " + processEngineConfiguration.getHistory());
    }

    public void checkHistoryLevel(DbEntityManager entityManager) {
        HistoryLevel configuredHistoryLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        PropertyEntity historyLevelProperty = entityManager.selectById(PropertyEntity.class, "historyLevel");
        if (historyLevelProperty == null) {
            log.info("No historyLevel property found in database.");
            SchemaOperationsProcessEngineBuild.dbCreateHistoryLevel(entityManager);
        } else {
            Integer databaseHistoryLevel = new Integer(historyLevelProperty.getValue());
            if (!Integer.valueOf(configuredHistoryLevel.getId()).equals(databaseHistoryLevel)) {
                throw new ProcessEngineException("historyLevel mismatch: configuration says " + configuredHistoryLevel + " and database says " + databaseHistoryLevel);
            }
        }
    }

    public void checkDeploymentLockExists(DbEntityManager entityManager) {
        PropertyEntity deploymentLockProperty = entityManager.selectById(PropertyEntity.class, "deployment.lock");
        if (deploymentLockProperty == null) {
            log.warning("No deployment lock property found in database.");
        }
    }
}

