/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.VariableInstanceQueryProperty;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.variable.type.ValueType;

public class VariableInstanceQueryImpl
extends AbstractVariableQueryImpl<VariableInstanceQuery, VariableInstance>
implements VariableInstanceQuery,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(VariableInstanceQuery.class.getName());
    private static final long serialVersionUID = 1L;
    protected String variableId;
    protected String variableName;
    protected String[] variableNames;
    protected String variableNameLike;
    protected String[] executionIds;
    protected String[] processInstanceIds;
    protected String[] caseExecutionIds;
    protected String[] caseInstanceIds;
    protected String[] taskIds;
    protected String[] variableScopeIds;
    protected String[] activityInstanceIds;
    protected boolean isByteArrayFetchingEnabled = true;
    protected boolean isCustomObjectDeserializationEnabled = true;
    protected List<PermissionCheck> taskPermissionChecks = new ArrayList<PermissionCheck>();

    public VariableInstanceQueryImpl() {
    }

    public VariableInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public VariableInstanceQuery variableId(String id) {
        EnsureUtil.ensureNotNull("id", (Object)id);
        this.variableId = id;
        return this;
    }

    @Override
    public VariableInstanceQuery variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    @Override
    public VariableInstanceQuery variableNameIn(String ... variableNames) {
        this.variableNames = variableNames;
        return this;
    }

    @Override
    public VariableInstanceQuery variableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
        return this;
    }

    @Override
    public VariableInstanceQuery executionIdIn(String ... executionIds) {
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public VariableInstanceQuery processInstanceIdIn(String ... processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery caseExecutionIdIn(String ... caseExecutionIds) {
        this.caseExecutionIds = caseExecutionIds;
        return this;
    }

    @Override
    public VariableInstanceQuery caseInstanceIdIn(String ... caseInstanceIds) {
        this.caseInstanceIds = caseInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery taskIdIn(String ... taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public VariableInstanceQuery variableScopeIdIn(String ... variableScopeIds) {
        this.variableScopeIds = variableScopeIds;
        return this;
    }

    @Override
    public VariableInstanceQuery activityInstanceIdIn(String ... activityInstanceIds) {
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery disableBinaryFetching() {
        this.isByteArrayFetchingEnabled = false;
        return this;
    }

    @Override
    public VariableInstanceQuery disableCustomObjectDeserialization() {
        this.isCustomObjectDeserializationEnabled = false;
        return this;
    }

    @Override
    public VariableInstanceQuery orderByVariableName() {
        this.orderBy(VariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByVariableType() {
        this.orderBy(VariableInstanceQueryProperty.VARIABLE_TYPE);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByActivityInstanceId() {
        this.orderBy(VariableInstanceQueryProperty.ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getVariableInstanceManager().findVariableInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<VariableInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<VariableInstance> result = commandContext.getVariableInstanceManager().findVariableInstanceByQueryCriteria(this, page);
        if (result == null) {
            return result;
        }
        for (VariableInstance variableInstance : result) {
            VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
            if (!this.shouldFetchValue(variableInstanceEntity)) continue;
            try {
                variableInstanceEntity.getTypedValue(this.isCustomObjectDeserializationEnabled);
            }
            catch (Exception t) {
                LOGGER.log(Level.FINE, "Exception while getting value for variable", t);
            }
        }
        return result;
    }

    protected boolean shouldFetchValue(VariableInstanceEntity entity) {
        return this.isByteArrayFetchingEnabled || !ValueType.BYTES.equals(entity.getSerializer().getType());
    }

    public String getVariableId() {
        return this.variableId;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public String[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String[] getCaseExecutionIds() {
        return this.caseExecutionIds;
    }

    public String[] getCaseInstanceIds() {
        return this.caseInstanceIds;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getVariableScopeIds() {
        return this.variableScopeIds;
    }

    public String[] getActivityInstanceIds() {
        return this.activityInstanceIds;
    }

    public List<PermissionCheck> getTaskPermissionChecks() {
        return this.taskPermissionChecks;
    }

    public void setTaskPermissionChecks(List<PermissionCheck> taskPermissionChecks) {
        this.taskPermissionChecks = taskPermissionChecks;
    }

    public void addTaskPermissionCheck(PermissionCheck permissionCheck) {
        this.taskPermissionChecks.add(permissionCheck);
    }
}

