/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ExclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static Logger log = Logger.getLogger(ExclusiveGatewayActivityBehavior.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void leave(ActivityExecution execution) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Leaving activity '" + execution.getActivity().getId() + "'");
        }
        PvmTransition outgoingSeqFlow = null;
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        Iterator<PvmTransition> transitionIterator = execution.getActivity().getOutgoingTransitions().iterator();
        while (outgoingSeqFlow == null && transitionIterator.hasNext()) {
            PvmTransition seqFlow = transitionIterator.next();
            Condition condition = (Condition)seqFlow.getProperty("condition");
            if ((condition != null || defaultSequenceFlow != null && defaultSequenceFlow.equals(seqFlow.getId())) && (condition == null || !condition.evaluate(execution))) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Sequence flow '" + seqFlow.getId() + " '" + "selected as outgoing sequence flow.");
            }
            outgoingSeqFlow = seqFlow;
        }
        if (outgoingSeqFlow != null) {
            execution.leaveActivityViaTransition(outgoingSeqFlow);
            return;
        } else {
            if (defaultSequenceFlow == null) throw new ProcessEngineException("No outgoing sequence flow of the exclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ProcessEngineException("Default sequence flow '" + defaultSequenceFlow + "' not found");
            execution.leaveActivityViaTransition(defaultTransition);
        }
    }
}

