/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.helper;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.VariableMapImpl;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class CompensationUtil {
    public static void throwCompensationEvent(List<CompensateEventSubscriptionEntity> eventSubscriptions, ActivityExecution execution, boolean async) {
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            ExecutionEntity compensatingExecution = null;
            if (eventSubscriptionEntity.getConfiguration() != null) {
                compensatingExecution = Context.getCommandContext().getExecutionManager().findExecutionById(eventSubscriptionEntity.getConfiguration());
                compensatingExecution.setParent((PvmExecutionImpl)execution);
                compensatingExecution.setEventScope(false);
            } else {
                compensatingExecution = (ExecutionEntity)execution.createExecution();
                eventSubscriptionEntity.setConfiguration(compensatingExecution.getId());
            }
            compensatingExecution.setConcurrent(true);
        }
        Collections.sort(eventSubscriptions, new Comparator<EventSubscriptionEntity>(){

            @Override
            public int compare(EventSubscriptionEntity o1, EventSubscriptionEntity o2) {
                return o2.getCreated().compareTo(o1.getCreated());
            }
        });
        for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
            compensateEventSubscriptionEntity.eventReceived(null, async);
        }
    }

    public static void createEventScopeExecution(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        PvmScope levelOfSubprocess = activity.getLevelOfSubprocessScope();
        ExecutionEntity levelOfSubprocessScopeExecution = (ExecutionEntity)execution.findExecutionForFlowScope(levelOfSubprocess);
        List<CompensateEventSubscriptionEntity> eventSubscriptions = execution.getCompensateEventSubscriptions();
        if (eventSubscriptions.size() > 0) {
            ExecutionEntity eventScopeExecution = levelOfSubprocessScopeExecution.createExecution();
            eventScopeExecution.setActivity(execution.getActivity());
            eventScopeExecution.enterActivityInstance();
            eventScopeExecution.setActive(false);
            eventScopeExecution.setConcurrent(false);
            eventScopeExecution.setEventScope(true);
            VariableMapImpl variables = execution.getVariablesLocal();
            for (Map.Entry entry : variables.entrySet()) {
                eventScopeExecution.setVariableLocal((String)entry.getKey(), entry.getValue());
            }
            for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
                CompensateEventSubscriptionEntity compensateEventSubscriptionEntity2 = compensateEventSubscriptionEntity.moveUnder(eventScopeExecution);
            }
            for (PvmExecutionImpl pvmExecutionImpl : execution.getEventScopeExecutions()) {
                pvmExecutionImpl.setParent(eventScopeExecution);
                eventScopeExecution.getExecutions().add((ExecutionEntity)pvmExecutionImpl);
                execution.getExecutions().remove(pvmExecutionImpl);
            }
            CompensateEventSubscriptionEntity eventSubscription = CompensateEventSubscriptionEntity.createAndInsert(levelOfSubprocessScopeExecution, execution.getActivity());
            eventSubscription.setConfiguration(eventScopeExecution.getId());
        }
    }
}

