/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.calendar;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;

public class DueDateBusinessCalendar
implements BusinessCalendar {
    public static final String NAME = "dueDate";

    @Override
    public Date resolveDuedate(String duedate) {
        try {
            if (duedate.startsWith("P")) {
                return DateTimeUtil.now().plus((ReadablePeriod)ISOPeriodFormat.standard().parsePeriod(duedate)).toDate();
            }
            return DateTimeUtil.parseDateTime(duedate).toDate();
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't resolve duedate: " + e.getMessage(), e);
        }
    }
}

