/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.exception.cmmn.CmmnModelInstanceNotFoundException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;

public class GetDeploymentCmmnModelInstanceCmd
implements Command<CmmnModelInstance> {
    protected String caseDefinitionId;

    public GetDeploymentCmmnModelInstanceCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public CmmnModelInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)this.caseDefinitionId);
        CmmnModelInstance modelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        EnsureUtil.ensureNotNull(CmmnModelInstanceNotFoundException.class, "No CMMN model instance found for case definition id " + this.caseDefinitionId, "modelInstance", (Object)modelInstance);
        return modelInstance;
    }
}

