/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetHistoricJobLogExceptionStacktraceCmd
implements Command<String> {
    protected String historicJobLogId;

    public GetHistoricJobLogExceptionStacktraceCmd(String historicJobLogId) {
        this.historicJobLogId = historicJobLogId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("historicJobLogId", (Object)this.historicJobLogId);
        HistoricJobLogEventEntity job = commandContext.getHistoricJobLogManager().findHistoricJobLogById(this.historicJobLogId);
        EnsureUtil.ensureNotNull("No historic job log found with id " + this.historicJobLogId, "historicJobLog", (Object)job);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadHistoricJobLog(job);
        return job.getExceptionStacktrace();
    }
}

