/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetTaskFormCmd
implements Command<TaskFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public TaskFormData execute(CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("No task found for taskId '" + this.taskId + "'", "task", (Object)task);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadTask(task);
        if (task.getTaskDefinition() != null) {
            TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
            EnsureUtil.ensureNotNull("No taskFormHandler specified for task '" + this.taskId + "'", "taskFormHandler", (Object)taskFormHandler);
            return taskFormHandler.createTaskForm(task);
        }
        return null;
    }
}

