/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class ModifyProcessInstanceCmd
implements Command<Void> {
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder) {
        this.builder = processInstanceModificationBuilder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstance(processInstance);
        processInstance.setPreserveScope(true);
        for (AbstractProcessInstanceModificationCommand instruction : this.builder.getModificationOperations()) {
            instruction.setSkipCustomListeners(this.builder.isSkipCustomListeners());
            instruction.setSkipIoMappings(this.builder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        processInstance = executionManager.findExecutionById(processInstanceId);
        if (processInstance.getExecutions().isEmpty()) {
            if (processInstance.getActivity() == null) {
                authorizationManager.checkDeleteProcessInstance(processInstance);
                processInstance.deleteCascade("Cancellation due to process instance modification", this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
            } else if (processInstance.isEnded()) {
                processInstance.performOperation(PvmAtomicOperation.PROCESS_END);
            }
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), processInstanceId, null, null, PropertyChange.EMPTY_CHANGE);
        return null;
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }
}

