/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class StartProcessInstanceAtActivitiesCmd
implements Command<ProcessInstance> {
    protected ProcessInstantiationBuilderImpl instantiationBuilder;

    public StartProcessInstanceAtActivitiesCmd(ProcessInstantiationBuilderImpl instantiationBuilder) {
        this.instantiationBuilder = instantiationBuilder;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        String processDefinitionId = this.instantiationBuilder.getProcessDefinitionId();
        String processDefinitionKey = this.instantiationBuilder.getProcessDefinitionKey();
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = null;
        if (processDefinitionId != null) {
            processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            EnsureUtil.ensureNotNull("No process definition found for id = '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        } else if (processDefinitionKey != null) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
            EnsureUtil.ensureNotNull("No process definition found for key '" + processDefinitionKey + "'", "processDefinition", (Object)processDefinition);
        } else {
            throw new ProcessEngineException("processDefinitionKey and processDefinitionId are null");
        }
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCreateProcessInstance(processDefinition);
        ProcessInstanceModificationBuilderImpl modificationBuilder = this.instantiationBuilder.getModificationBuilder();
        EnsureUtil.ensureNotEmpty("At least one instantiation instruction required (e.g. by invoking startBefore(..), startAfter(..) or startTransition(..))", "instructions", modificationBuilder.getModificationOperations());
        ActivityImpl initialActivity = this.determineFirstActivity(processDefinition, modificationBuilder);
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.instantiationBuilder.getBusinessKey(), this.instantiationBuilder.getCaseInstanceId(), initialActivity);
        processInstance.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
        processInstance.startWithoutExecuting();
        processInstance.setActivity(null);
        processInstance.setActivityInstanceId(processInstance.getId());
        processInstance.setVariables(modificationBuilder.getProcessVariables());
        processInstance.setPreserveScope(true);
        for (AbstractProcessInstanceModificationCommand instruction : modificationBuilder.getModificationOperations()) {
            instruction.setProcessInstanceId(processInstance.getId());
            instruction.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
            instruction.setSkipIoMappings(modificationBuilder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        if (processInstance.getExecutions().isEmpty() && processInstance.isEnded()) {
            processInstance.propagateEnd();
        }
        return processInstance;
    }

    protected ActivityImpl determineFirstActivity(ProcessDefinitionImpl processDefinition, ProcessInstanceModificationBuilderImpl modificationBuilder) {
        AbstractProcessInstanceModificationCommand firstInstruction = modificationBuilder.getModificationOperations().get(0);
        if (firstInstruction instanceof AbstractInstantiationCmd) {
            AbstractInstantiationCmd instantiationInstruction = (AbstractInstantiationCmd)firstInstruction;
            CoreModelElement targetElement = instantiationInstruction.getTargetElement(processDefinition);
            EnsureUtil.ensureNotNull(NotValidException.class, "Element '" + instantiationInstruction.getTargetElementId() + "' does not exist in process " + processDefinition.getId(), "targetElement", (Object)targetElement);
            if (targetElement instanceof ActivityImpl) {
                return (ActivityImpl)targetElement;
            }
            if (targetElement instanceof TransitionImpl) {
                return (ActivityImpl)((TransitionImpl)targetElement).getDestination();
            }
        }
        return null;
    }
}

