/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.engine;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormFieldValidationConstraint;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.form.engine.FormEngine;
import org.camunda.bpm.engine.impl.form.engine.FormPropertyAdapter;
import org.camunda.bpm.engine.impl.form.engine.HtmlDocumentBuilder;
import org.camunda.bpm.engine.impl.form.engine.HtmlElementWriter;
import org.camunda.bpm.engine.impl.form.type.EnumFormType;

public class HtmlFormEngine
implements FormEngine {
    protected static final String FORM_ELEMENT = "form";
    protected static final String DIV_ELEMENT = "div";
    protected static final String SPAN_ELEMENT = "span";
    protected static final String LABEL_ELEMENT = "label";
    protected static final String INPUT_ELEMENT = "input";
    protected static final String BUTTON_ELEMENT = "button";
    protected static final String SELECT_ELEMENT = "select";
    protected static final String OPTION_ELEMENT = "option";
    protected static final String I_ELEMENT = "i";
    protected static final String SCRIPT_ELEMENT = "script";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final String ROLE_ATTRIBUTE = "role";
    protected static final String FOR_ATTRIBUTE = "for";
    protected static final String VALUE_ATTRIBUTE = "value";
    protected static final String TYPE_ATTRIBUTE = "type";
    protected static final String SELECTED_ATTRIBUTE = "selected";
    protected static final String IS_OPEN_ATTRIBUTE = "is-open";
    protected static final String DATEPICKER_POPUP_ATTRIBUTE = "datepicker-popup";
    protected static final String CAM_VARIABLE_TYPE_ATTRIBUTE = "cam-variable-type";
    protected static final String CAM_VARIABLE_NAME_ATTRIBUTE = "cam-variable-name";
    protected static final String CAM_SCRIPT_ATTRIBUTE = "cam-script";
    protected static final String NG_CLICK_ATTRIBUTE = "ng-click";
    protected static final String NG_IF_ATTRIBUTE = "ng-if";
    protected static final String NG_SHOW_ATTRIBUTE = "ng-show";
    protected static final String FORM_GROUP_CLASS = "form-group";
    protected static final String FORM_CONTROL_CLASS = "form-control";
    protected static final String INPUT_GROUP_CLASS = "input-group";
    protected static final String INPUT_GROUP_BTN_CLASS = "input-group-btn";
    protected static final String BUTTON_DEFAULT_CLASS = "btn btn-default";
    protected static final String HAS_ERROR_CLASS = "has-error";
    protected static final String HELP_BLOCK_CLASS = "help-block";
    protected static final String TEXT_INPUT_TYPE = "text";
    protected static final String CHECKBOX_INPUT_TYPE = "checkbox";
    protected static final String BUTTON_BUTTON_TYPE = "button";
    protected static final String TEXT_FORM_SCRIPT_TYPE = "text/form-script";
    protected static final String CALENDAR_GLYPHICON = "glyphicon glyphicon-calendar";
    protected static final String GENERATED_FORM_NAME = "generatedForm";
    protected static final String FORM_ROLE = "form";
    protected static final String REQUIRED_ERROR_TYPE = "required";
    protected static final String DATE_ERROR_TYPE = "date";
    protected static final String FORM_ELEMENT_SELECTOR = "this.generatedForm.%s";
    protected static final String INVALID_EXPRESSION = "this.generatedForm.%s.$invalid";
    protected static final String DIRTY_EXPRESSION = "this.generatedForm.%s.$dirty";
    protected static final String ERROR_EXPRESSION = "this.generatedForm.%s.$error";
    protected static final String DATE_ERROR_EXPRESSION = "this.generatedForm.%s.$error.date";
    protected static final String REQUIRED_ERROR_EXPRESSION = "this.generatedForm.%s.$error.required";
    protected static final String TYPE_ERROR_EXPRESSION = "this.generatedForm.%s.$error.camVariableType";
    protected static final String DATE_FIELD_OPENED_ATTRIBUTE = "dateFieldOpened%s";
    protected static final String OPEN_DATEPICKER_SNIPPET = "$scope.open%s = function ($event) { $event.preventDefault(); $event.stopPropagation(); $scope.dateFieldOpened%s = true; };";
    protected static final String OPEN_DATEPICKER_FUNCTION_SNIPPET = "open%s($event)";
    protected static final String DATE_FORMAT = "dd/MM/yyyy";
    protected static final String REQUIRED_FIELD_MESSAGE = "Required field";
    protected static final String TYPE_FIELD_MESSAGE = "Only a %s value is allowed";
    protected static final String INVALID_DATE_FIELD_MESSAGE = "Invalid date format: the date should have the pattern 'dd/MM/yyyy'";

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public Object renderStartForm(StartFormData startForm) {
        return this.renderFormData(startForm);
    }

    @Override
    public Object renderTaskForm(TaskFormData taskForm) {
        return this.renderFormData(taskForm);
    }

    protected String renderFormData(FormData formData) {
        if (formData == null || (formData.getFormFields() == null || formData.getFormFields().isEmpty()) && (formData.getFormProperties() == null || formData.getFormProperties().isEmpty())) {
            return null;
        }
        HtmlElementWriter formElement = new HtmlElementWriter("form").attribute(NAME_ATTRIBUTE, GENERATED_FORM_NAME).attribute(ROLE_ATTRIBUTE, "form");
        HtmlDocumentBuilder documentBuilder = new HtmlDocumentBuilder(formElement);
        for (FormField formField : formData.getFormFields()) {
            this.renderFormField(formField, documentBuilder);
        }
        for (FormProperty formProperty : formData.getFormProperties()) {
            this.renderFormField(new FormPropertyAdapter(formProperty), documentBuilder);
        }
        documentBuilder.endElement();
        return documentBuilder.getHtmlString();
    }

    protected void renderFormField(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter divElement = new HtmlElementWriter(DIV_ELEMENT).attribute(CLASS_ATTRIBUTE, FORM_GROUP_CLASS);
        documentBuilder.startElement(divElement);
        String formFieldId = formField.getId();
        String formFieldLabel = formField.getLabel();
        if (formFieldLabel != null && !formFieldLabel.isEmpty()) {
            HtmlElementWriter labelElement = new HtmlElementWriter(LABEL_ELEMENT).attribute(FOR_ATTRIBUTE, formFieldId).textContent(formFieldLabel);
            documentBuilder.startElement(labelElement).endElement();
        }
        if (this.isEnum(formField)) {
            this.renderSelectBox(formField, documentBuilder);
        } else if (this.isDate(formField)) {
            this.renderDatePicker(formField, documentBuilder);
        } else {
            this.renderInputField(formField, documentBuilder);
        }
        this.renderInvalidMessageElement(formField, documentBuilder);
        documentBuilder.endElement();
    }

    protected HtmlElementWriter createInputField(FormField formField) {
        HtmlElementWriter inputField = new HtmlElementWriter(INPUT_ELEMENT, true);
        this.addCommonFormFieldAttributes(formField, inputField);
        inputField.attribute(TYPE_ATTRIBUTE, TEXT_INPUT_TYPE);
        return inputField;
    }

    protected void renderDatePicker(FormField formField, HtmlDocumentBuilder documentBuilder) {
        boolean isReadOnly = this.isReadOnly(formField);
        HtmlElementWriter inputGroupDivElement = new HtmlElementWriter(DIV_ELEMENT).attribute(CLASS_ATTRIBUTE, INPUT_GROUP_CLASS);
        String formFieldId = formField.getId();
        documentBuilder.startElement(inputGroupDivElement);
        HtmlElementWriter inputField = this.createInputField(formField);
        if (!isReadOnly) {
            inputField.attribute(DATEPICKER_POPUP_ATTRIBUTE, DATE_FORMAT).attribute(IS_OPEN_ATTRIBUTE, String.format(DATE_FIELD_OPENED_ATTRIBUTE, formFieldId));
        }
        documentBuilder.startElement(inputField).endElement();
        if (!isReadOnly) {
            HtmlElementWriter addonElement = new HtmlElementWriter(DIV_ELEMENT).attribute(CLASS_ATTRIBUTE, INPUT_GROUP_BTN_CLASS);
            documentBuilder.startElement(addonElement);
            HtmlElementWriter buttonElement = new HtmlElementWriter("button").attribute(TYPE_ATTRIBUTE, "button").attribute(CLASS_ATTRIBUTE, BUTTON_DEFAULT_CLASS).attribute(NG_CLICK_ATTRIBUTE, String.format(OPEN_DATEPICKER_FUNCTION_SNIPPET, formFieldId));
            documentBuilder.startElement(buttonElement);
            HtmlElementWriter iconElement = new HtmlElementWriter(I_ELEMENT).attribute(CLASS_ATTRIBUTE, CALENDAR_GLYPHICON);
            documentBuilder.startElement(iconElement).endElement();
            documentBuilder.endElement();
            documentBuilder.endElement();
            HtmlElementWriter scriptElement = new HtmlElementWriter(SCRIPT_ELEMENT).attribute(CAM_SCRIPT_ATTRIBUTE, null).attribute(TYPE_ATTRIBUTE, TEXT_FORM_SCRIPT_TYPE).textContent(String.format(OPEN_DATEPICKER_SNIPPET, formFieldId, formFieldId));
            documentBuilder.startElement(scriptElement).endElement();
        }
        documentBuilder.endElement();
    }

    protected void renderInputField(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter inputField = new HtmlElementWriter(INPUT_ELEMENT, true);
        this.addCommonFormFieldAttributes(formField, inputField);
        String inputType = !this.isBoolean(formField) ? TEXT_INPUT_TYPE : CHECKBOX_INPUT_TYPE;
        inputField.attribute(TYPE_ATTRIBUTE, inputType);
        Object defaultValue = formField.getDefaultValue();
        if (defaultValue != null) {
            inputField.attribute(VALUE_ATTRIBUTE, defaultValue.toString());
        }
        documentBuilder.startElement(inputField).endElement();
    }

    protected void renderSelectBox(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter selectBox = new HtmlElementWriter(SELECT_ELEMENT, false);
        this.addCommonFormFieldAttributes(formField, selectBox);
        documentBuilder.startElement(selectBox);
        this.renderSelectOptions(formField, documentBuilder);
        documentBuilder.endElement();
    }

    protected void renderSelectOptions(FormField formField, HtmlDocumentBuilder documentBuilder) {
        EnumFormType enumFormType = (EnumFormType)formField.getType();
        Map<String, String> values = enumFormType.getValues();
        for (Map.Entry<String, String> value : values.entrySet()) {
            HtmlElementWriter option = new HtmlElementWriter(OPTION_ELEMENT, false).attribute(VALUE_ATTRIBUTE, value.getKey()).textContent(value.getValue());
            documentBuilder.startElement(option).endElement();
        }
    }

    protected void renderInvalidMessageElement(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter divElement = new HtmlElementWriter(DIV_ELEMENT);
        String formFieldId = formField.getId();
        String ifExpression = String.format("this.generatedForm.%s.$invalid && this.generatedForm.%s.$dirty", formFieldId, formFieldId);
        divElement.attribute(NG_IF_ATTRIBUTE, ifExpression).attribute(CLASS_ATTRIBUTE, HAS_ERROR_CLASS);
        documentBuilder.startElement(divElement);
        if (!this.isDate(formField)) {
            this.renderInvalidValueMessage(formField, documentBuilder);
            this.renderInvalidTypeMessage(formField, documentBuilder);
        } else {
            this.renderInvalidDateMessage(formField, documentBuilder);
        }
        documentBuilder.endElement();
    }

    protected void renderInvalidValueMessage(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter divElement = new HtmlElementWriter(DIV_ELEMENT);
        String formFieldId = formField.getId();
        String expression = String.format(REQUIRED_ERROR_EXPRESSION, formFieldId);
        divElement.attribute(NG_SHOW_ATTRIBUTE, expression).attribute(CLASS_ATTRIBUTE, HELP_BLOCK_CLASS).textContent(REQUIRED_FIELD_MESSAGE);
        documentBuilder.startElement(divElement).endElement();
    }

    protected void renderInvalidTypeMessage(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter divElement = new HtmlElementWriter(DIV_ELEMENT);
        String formFieldId = formField.getId();
        String expression = String.format(TYPE_ERROR_EXPRESSION, formFieldId);
        String typeName = formField.getTypeName();
        if (this.isEnum(formField)) {
            typeName = "string";
        }
        divElement.attribute(NG_SHOW_ATTRIBUTE, expression).attribute(CLASS_ATTRIBUTE, HELP_BLOCK_CLASS).textContent(String.format(TYPE_FIELD_MESSAGE, typeName));
        documentBuilder.startElement(divElement).endElement();
    }

    protected void renderInvalidDateMessage(FormField formField, HtmlDocumentBuilder documentBuilder) {
        String formFieldId = formField.getId();
        HtmlElementWriter firstDivElement = new HtmlElementWriter(DIV_ELEMENT);
        String firstExpression = String.format("this.generatedForm.%s.$error.required && !this.generatedForm.%s.$error.date", formFieldId, formFieldId);
        firstDivElement.attribute(NG_SHOW_ATTRIBUTE, firstExpression).attribute(CLASS_ATTRIBUTE, HELP_BLOCK_CLASS).textContent(REQUIRED_FIELD_MESSAGE);
        documentBuilder.startElement(firstDivElement).endElement();
        HtmlElementWriter secondDivElement = new HtmlElementWriter(DIV_ELEMENT);
        String secondExpression = String.format(DATE_ERROR_EXPRESSION, formFieldId);
        secondDivElement.attribute(NG_SHOW_ATTRIBUTE, secondExpression).attribute(CLASS_ATTRIBUTE, HELP_BLOCK_CLASS).textContent(INVALID_DATE_FIELD_MESSAGE);
        documentBuilder.startElement(secondDivElement).endElement();
    }

    protected void addCommonFormFieldAttributes(FormField formField, HtmlElementWriter formControl) {
        String typeName = formField.getTypeName();
        if (this.isEnum(formField) || this.isDate(formField)) {
            typeName = "string";
        }
        typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        String formFieldId = formField.getId();
        formControl.attribute(CLASS_ATTRIBUTE, FORM_CONTROL_CLASS).attribute(NAME_ATTRIBUTE, formFieldId).attribute(CAM_VARIABLE_TYPE_ATTRIBUTE, typeName).attribute(CAM_VARIABLE_NAME_ATTRIBUTE, formFieldId);
        for (FormFieldValidationConstraint constraint : formField.getValidationConstraints()) {
            String constraintName = constraint.getName();
            String configuration = (String)constraint.getConfiguration();
            formControl.attribute(constraintName, configuration);
        }
    }

    protected boolean isEnum(FormField formField) {
        return "enum".equals(formField.getTypeName());
    }

    protected boolean isDate(FormField formField) {
        return DATE_ERROR_TYPE.equals(formField.getTypeName());
    }

    protected boolean isBoolean(FormField formField) {
        return "boolean".equals(formField.getTypeName());
    }

    protected boolean isReadOnly(FormField formField) {
        List<FormFieldValidationConstraint> validationConstraints = formField.getValidationConstraints();
        if (validationConstraints != null) {
            for (FormFieldValidationConstraint validationConstraint : validationConstraints) {
                if (!"readonly".equals(validationConstraint.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

