/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.parser;

import java.util.List;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.parser.ActivityInstanceEndListener;
import org.camunda.bpm.engine.impl.history.parser.ActivityInstanceStartListener;
import org.camunda.bpm.engine.impl.history.parser.ActivityInstanceUpdateListener;
import org.camunda.bpm.engine.impl.history.parser.ProcessInstanceEndListener;
import org.camunda.bpm.engine.impl.history.parser.ProcessInstanceStartListener;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;

public class HistoryParseListener
implements BpmnParseListener {
    protected ExecutionListener PROCESS_INSTANCE_START_LISTENER;
    protected ExecutionListener PROCESS_INSTANCE_END_LISTENER;
    protected ExecutionListener ACTIVITY_INSTANCE_START_LISTENER;
    protected ExecutionListener ACTIVITY_INSTANCE_END_LISTENER;
    protected TaskListener USER_TASK_ASSIGNMENT_HANDLER;
    protected TaskListener USER_TASK_ID_HANDLER;
    protected HistoryLevel historyLevel;

    public HistoryParseListener(HistoryLevel historyLevel, HistoryEventProducer historyEventProducer) {
        this.historyLevel = historyLevel;
        this.initExecutionListeners(historyEventProducer, historyLevel);
    }

    protected void initExecutionListeners(HistoryEventProducer historyEventProducer, HistoryLevel historyLevel) {
        this.PROCESS_INSTANCE_START_LISTENER = new ProcessInstanceStartListener(historyEventProducer, historyLevel);
        this.PROCESS_INSTANCE_END_LISTENER = new ProcessInstanceEndListener(historyEventProducer, historyLevel);
        this.ACTIVITY_INSTANCE_START_LISTENER = new ActivityInstanceStartListener(historyEventProducer, historyLevel);
        this.ACTIVITY_INSTANCE_END_LISTENER = new ActivityInstanceEndListener(historyEventProducer, historyLevel);
        this.USER_TASK_ID_HANDLER = this.USER_TASK_ASSIGNMENT_HANDLER = new ActivityInstanceUpdateListener(historyEventProducer, historyLevel);
    }

    @Override
    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_END, null)) {
            processDefinition.addBuiltInListener("end", this.PROCESS_INSTANCE_END_LISTENER);
        }
    }

    @Override
    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_CREATE, null)) {
            TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activity.getActivityBehavior()).getTaskDefinition();
            taskDefinition.addTaskListener("assignment", this.USER_TASK_ASSIGNMENT_HANDLER);
            taskDefinition.addTaskListener("create", this.USER_TASK_ID_HANDLER);
        }
    }

    @Override
    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        Object property = activity.getProperty("triggeredByEvent");
        if (property == null || !((Boolean)property).booleanValue()) {
            this.addActivityHandlers(activity);
        }
    }

    @Override
    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl timerActivity) {
    }

    @Override
    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
    }

    @Override
    public void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity) {
    }

    @Override
    public void parseProperty(Element propertyElement, VariableDeclaration variableDeclaration, ActivityImpl activity) {
    }

    @Override
    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
    }

    @Override
    public void parseRootElement(Element rootElement, List<ProcessDefinitionEntity> processDefinitions) {
    }

    @Override
    public void parseBoundarySignalEventDefinition(Element signalEventDefinition, boolean interrupting, ActivityImpl signalActivity) {
    }

    @Override
    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateSignalCatchEventDefinition(Element signalEventDefinition, ActivityImpl signalActivity) {
    }

    @Override
    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl compensationActivity) {
    }

    @Override
    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        if (!activity.getProperty("type").equals("intermediateLinkCatch")) {
            this.addActivityHandlers(activity);
        }
    }

    @Override
    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateMessageCatchEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity) {
    }

    @Override
    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl messageActivity) {
    }

    protected void addActivityHandlers(ActivityImpl activity) {
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_START, null)) {
            activity.addBuiltInListener("start", this.ACTIVITY_INSTANCE_START_LISTENER, 0);
        }
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_END, null)) {
            activity.addBuiltInListener("end", this.ACTIVITY_INSTANCE_END_LISTENER);
        }
    }
}

