/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.incident;

import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.runtime.Incident;

public class FailedJobIncidentHandler
implements IncidentHandler {
    public static final String INCIDENT_HANDLER_TYPE = "failedJob";

    @Override
    public String getIncidentHandlerType() {
        return INCIDENT_HANDLER_TYPE;
    }

    @Override
    public void handleIncident(String processDefinitionId, String activityId, String executionId, String jobId, String message) {
        this.createIncident(processDefinitionId, activityId, executionId, jobId, message);
    }

    public Incident createIncident(String processDefinitionId, String activityId, String executionId, String jobId, String message) {
        IncidentEntity newIncident;
        if (executionId != null) {
            newIncident = IncidentEntity.createAndInsertIncident(INCIDENT_HANDLER_TYPE, executionId, jobId, message);
            newIncident.createRecursiveIncidents();
        } else {
            newIncident = IncidentEntity.createAndInsertIncident(INCIDENT_HANDLER_TYPE, processDefinitionId, activityId, jobId, message);
        }
        return newIncident;
    }

    @Override
    public void resolveIncident(String processDefinitionId, String activityId, String executionId, String configuration) {
        this.removeIncident(processDefinitionId, activityId, executionId, configuration, true);
    }

    @Override
    public void deleteIncident(String processDefinitionId, String activityId, String executionId, String configuration) {
        this.removeIncident(processDefinitionId, activityId, executionId, configuration, false);
    }

    protected void removeIncident(String processDefinitionId, String activityId, String executionId, String configuration, boolean incidentResolved) {
        List<Incident> incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfiguration(configuration);
        for (Incident currentIncident : incidents) {
            IncidentEntity incident = (IncidentEntity)currentIncident;
            if (incidentResolved) {
                incident.resolve();
                continue;
            }
            incident.delete();
        }
    }
}

