/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;

public class ExecuteJobsRunnable
implements Runnable {
    private static final Logger LOGG = Logger.getLogger(ExecuteJobsRunnable.class.getName());
    protected final List<String> jobIds;
    protected JobExecutor jobExecutor;
    protected ProcessEngineImpl processEngine;

    public ExecuteJobsRunnable(JobExecutor jobExecutor, List<String> jobIds) {
        this.jobExecutor = jobExecutor;
        this.jobIds = jobIds;
    }

    public ExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        this.jobIds = jobIds;
        this.processEngine = processEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            JobExecutorContext jobExecutorContext = new JobExecutorContext();
            List<String> currentProcessorJobQueue = jobExecutorContext.getCurrentProcessorJobQueue();
            CommandExecutor commandExecutor = null;
            commandExecutor = this.processEngine == null ? this.jobExecutor.getCommandExecutor() : this.processEngine.getProcessEngineConfiguration().getCommandExecutorTxRequired();
            currentProcessorJobQueue.addAll(this.jobIds);
            Context.setJobExecutorContext(jobExecutorContext);
            block5: while (true) {
                while (!currentProcessorJobQueue.isEmpty()) {
                    String nextJobId = currentProcessorJobQueue.remove(0);
                    try {
                        this.executeJob(nextJobId, commandExecutor);
                        continue block5;
                    }
                    catch (Throwable t) {
                        LOGG.log(Level.WARNING, "Exception while executing job with id " + nextJobId, t);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                Context.removeJobExecutorContext();
            }
        }
    }

    protected void executeJob(String nextJobId, CommandExecutor commandExecutor) {
        commandExecutor.execute(new ExecuteJobsCmd(nextJobId));
    }
}

