/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics.reporter;

import java.util.ArrayList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class MetricsCollectionTask
extends TimerTask {
    protected static final Logger log = Logger.getLogger(MetricsCollectionTask.class.getName());
    protected MetricsRegistry metricsRegistry;
    protected CommandExecutor commandExecutor;

    public MetricsCollectionTask(MetricsRegistry metricsRegistry, CommandExecutor commandExecutor) {
        this.metricsRegistry = metricsRegistry;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void run() {
        try {
            this.collectMetrics();
        }
        catch (Exception e) {
            try {
                log.log(Level.WARNING, "Could not collect and log metrics", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void collectMetrics() {
        final ArrayList<MeterLogEntity> logs = new ArrayList<MeterLogEntity>();
        for (Meter meter : this.metricsRegistry.getMeters().values()) {
            logs.add(new MeterLogEntity(meter.getName(), meter.getAndClear(), ClockUtil.getCurrentTime()));
        }
        this.commandExecutor.execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                for (MeterLogEntity meterLogEntity : logs) {
                    commandContext.getMeterLogManager().insert(meterLogEntity);
                }
                return null;
            }
        });
    }
}

