/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Job;

public class HistoricJobLogManager
extends AbstractManager {
    public HistoricJobLogEventEntity findHistoricJobLogById(String historicJobLogId) {
        return (HistoricJobLogEventEntity)this.getDbEntityManager().selectOne("selectHistoricJobLog", historicJobLogId);
    }

    public List<HistoricJobLog> findHistoricJobLogsByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectHistoricJobLogByDeploymentId", deploymentId);
    }

    public List<HistoricJobLog> findHistoricJobLogsByQueryCriteria(HistoricJobLogQueryImpl query, Page page) {
        this.getAuthorizationManager().configureHistoricJobLogQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricJobLogByQueryCriteria", query, page);
    }

    public long findHistoricJobLogsCountByQueryCriteria(HistoricJobLogQueryImpl query) {
        this.getAuthorizationManager().configureHistoricJobLogQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricJobLogCountByQueryCriteria", query);
    }

    public void deleteHistoricJobLogById(String id) {
        this.deleteExceptionByteArrayByParameterMap("id", id);
        this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogById", id);
    }

    public void deleteHistoricJobLogByJobId(String jobId) {
        this.deleteExceptionByteArrayByParameterMap("jobId", jobId);
        this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByJobId", jobId);
    }

    public void deleteHistoricJobLogsByProcessInstanceId(String processInstanceId) {
        this.deleteExceptionByteArrayByParameterMap("processInstanceId", processInstanceId);
        this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByProcessInstanceId", processInstanceId);
    }

    public void deleteHistoricJobLogsByProcessDefinitionId(String processDefinitionId) {
        this.deleteExceptionByteArrayByParameterMap("processDefinitionId", processDefinitionId);
        this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByProcessDefinitionId", processDefinitionId);
    }

    public void deleteHistoricJobLogsByDeploymentId(String deploymentId) {
        this.deleteExceptionByteArrayByParameterMap("deploymentId", deploymentId);
        this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByDeploymentId", deploymentId);
    }

    public void deleteHistoricJobLogsByHandlerType(String handlerType) {
        this.deleteExceptionByteArrayByParameterMap("handlerType", handlerType);
        this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByHandlerType", handlerType);
    }

    protected void deleteExceptionByteArrayByParameterMap(String key, String value) {
        EnsureUtil.ensureNotNull(key, (Object)value);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put(key, value);
        this.getDbEntityManager().delete(ByteArrayEntity.class, "deleteExceptionByteArraysByIds", parameterMap);
    }

    public void fireJobCreatedEvent(Job job) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_CREATE, job)) {
            HistoryEventProducer eventProducer = this.getHistoryEventProducer();
            HistoryEvent event = eventProducer.createHistoricJobLogCreateEvt(job);
            this.handleEvent(event);
        }
    }

    public void fireJobFailedEvent(Job job, Throwable exception) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_FAIL, job)) {
            HistoryEventProducer eventProducer = this.getHistoryEventProducer();
            HistoryEvent event = eventProducer.createHistoricJobLogFailedEvt(job, exception);
            this.handleEvent(event);
        }
    }

    public void fireJobSuccessfulEvent(Job job) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_SUCCESS, job)) {
            HistoryEventProducer eventProducer = this.getHistoryEventProducer();
            HistoryEvent event = eventProducer.createHistoricJobLogSuccessfulEvt(job);
            this.handleEvent(event);
        }
    }

    public void fireJobDeletedEvent(Job job) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_DELETE, job)) {
            HistoryEventProducer eventProducer = this.getHistoryEventProducer();
            HistoryEvent event = eventProducer.createHistoricJobLogDeleteEvt(job);
            this.handleEvent(event);
        }
    }

    protected void handleEvent(HistoryEvent event) {
        HistoryEventHandler eventHandler = this.getHistoryEventHandler();
        eventHandler.handleEvent(event);
    }

    protected HistoryEventProducer getHistoryEventProducer() {
        return Context.getProcessEngineConfiguration().getHistoryEventProducer();
    }

    protected HistoryEventHandler getHistoryEventHandler() {
        return Context.getProcessEngineConfiguration().getHistoryEventHandler();
    }

    protected boolean isHistoryEventProduced(HistoryEventType eventType, Job job) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        return historyLevel.isHistoryEventProduced(eventType, job);
    }
}

