/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class MeterLogManager
extends AbstractManager {
    public void insert(MeterLogEntity meterLogEntity) {
        this.getDbEntityManager().insert(meterLogEntity);
    }

    public Long executeSelectSum(MetricsQueryImpl query) {
        Meter meter;
        Long result = (Long)this.getDbEntityManager().selectOne("selectMeterLogSum", query);
        result = result != null ? result : 0L;
        if (this.shouldAddCurrentUnloggedCount(query) && (meter = Context.getProcessEngineConfiguration().getMetricsRegistry().getMeterByName(query.getName())) != null) {
            result = result + meter.get();
        }
        return result;
    }

    protected boolean shouldAddCurrentUnloggedCount(MetricsQueryImpl query) {
        long reportingIntervalInSeconds = Context.getProcessEngineConfiguration().getDbMetricsReporter().getReportingIntervalInSeconds();
        return query.getName() != null && (query.getEndDate() == null || query.getEndDate().getTime() >= ClockUtil.getCurrentTime().getTime() - 1000L * reportingIntervalInSeconds);
    }

    public void deleteAll() {
        this.getDbEntityManager().delete(MeterLogEntity.class, "deleteAllMeterLogEntries", null);
    }

    public void deleteByTimestamp(Date timestamp) {
        this.getDbEntityManager().delete(MeterLogEntity.class, "deleteMeterLogEntriesByTimestamp", timestamp);
    }
}

