/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.history.UserOperationLogContext;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.UserOperationLogQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class UserOperationLogManager
extends AbstractHistoricManager {
    public UserOperationLogEntry findOperationLogById(String entryId) {
        return this.getDbEntityManager().selectById(UserOperationLogEntryEventEntity.class, entryId);
    }

    public long findOperationLogEntryCountByQueryCriteria(UserOperationLogQueryImpl query) {
        this.getAuthorizationManager().configureUserOperationLogQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectUserOperationLogEntryCountByQueryCriteria", query);
    }

    public List<UserOperationLogEntry> findOperationLogEntriesByQueryCriteria(UserOperationLogQueryImpl query, Page page) {
        this.getAuthorizationManager().configureUserOperationLogQuery(query);
        return this.getDbEntityManager().selectList("selectUserOperationLogEntriesByQueryCriteria", query, page);
    }

    public void deleteOperationLogEntriesByProcessInstanceId(String historicProcessInstanceId) {
        this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntriesByProcessInstanceId", historicProcessInstanceId);
    }

    public void deleteOperationLogEntriesByCaseInstanceId(String caseInstanceId) {
        this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntriesByCaseInstanceId", caseInstanceId);
    }

    public void deleteOperationLogEntriesByCaseDefinitionId(String caseInstanceId) {
        this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntriesByCaseDefinitionId", caseInstanceId);
    }

    public void deleteOperationLogEntriesByTaskId(String taskId) {
        this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntriesByTaskId", taskId);
    }

    public void deleteOperationLogEntriesByProcessDefinitionId(String processDefinitionId) {
        this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntriesByProcessDefinitionId", processDefinitionId);
    }

    public void deleteOperationLogEntriesByProcessDefinitionKey(String processDefinitionKey) {
        this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntriesByProcessDefinitionKey", processDefinitionKey);
    }

    public void deleteOperationLogEntryById(String entryId) {
        if (this.isHistoryLevelFullEnabled()) {
            this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntryById", entryId);
        }
    }

    public void logUserOperations(UserOperationLogContext context) {
        if (this.isHistoryLevelFullEnabled()) {
            ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            List<HistoryEvent> historyEvents = eventProducer.createUserOperationLogEvents(context);
            eventHandler.handleEvents(historyEvents);
        }
    }

    public void logTaskOperations(String operation, TaskEntity task, List<PropertyChange> propertyChanges) {
        if (this.isHistoryLevelFullEnabled()) {
            UserOperationLogContext context = this.createContextForTask("Task", operation, task, propertyChanges);
            this.logUserOperations(context);
        }
    }

    public void logLinkOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            UserOperationLogContext context = this.createContextForTask("IdentityLink", operation, task, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logProcessInstanceOperation(String operation, String processInstanceId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            ProcessDefinitionEntity definition;
            if (processInstanceId != null) {
                ExecutionEntity instance = this.getProcessInstanceManager().findExecutionById(processInstanceId);
                if (instance != null) {
                    ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)instance.getProcessDefinition();
                    processDefinitionId = processDefinition.getId();
                    processDefinitionKey = processDefinition.getKey();
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                processDefinitionKey = definition.getKey();
            }
            UserOperationLogContext context = this.createContextForProcessInstance(operation, processInstanceId, processDefinitionId, processDefinitionKey, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logProcessDefinitionOperation(String operation, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            ProcessDefinitionEntity definition;
            if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                processDefinitionKey = definition.getKey();
            }
            UserOperationLogContext context = this.createContextForProcessDefinition(operation, processDefinitionId, processDefinitionKey, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logJobOperation(String operation, String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            ProcessDefinitionEntity definition;
            if (jobId != null) {
                JobEntity job = this.getJobManager().findJobById(jobId);
                if (job != null) {
                    jobDefinitionId = job.getJobDefinitionId();
                    processInstanceId = job.getProcessInstanceId();
                    processDefinitionId = job.getProcessDefinitionId();
                    processDefinitionKey = job.getProcessDefinitionKey();
                }
            } else if (jobDefinitionId != null) {
                JobDefinitionEntity jobDefinition = this.getJobDefinitionManager().findById(jobDefinitionId);
                if (jobDefinition != null) {
                    processDefinitionId = jobDefinition.getProcessDefinitionId();
                    processDefinitionKey = jobDefinition.getProcessDefinitionKey();
                }
            } else if (processInstanceId != null) {
                ExecutionEntity processInstance = this.getProcessInstanceManager().findExecutionById(processInstanceId);
                if (processInstance != null) {
                    processDefinitionId = processInstance.getProcessDefinitionId();
                    processDefinitionKey = ((ProcessDefinitionEntity)processInstance.getProcessDefinition()).getKey();
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                processDefinitionKey = definition.getKey();
            }
            UserOperationLogContext context = this.createContextForJob(operation, jobId, jobDefinitionId, processInstanceId, processDefinitionId, processDefinitionKey, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logJobDefinitionOperation(String operation, String jobDefinitionId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            ProcessDefinitionEntity definition;
            if (jobDefinitionId != null) {
                JobDefinitionEntity jobDefinition = this.getJobDefinitionManager().findById(jobDefinitionId);
                if (jobDefinition != null) {
                    processDefinitionId = jobDefinition.getProcessDefinitionId();
                    processDefinitionKey = jobDefinition.getProcessDefinitionKey();
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                processDefinitionKey = definition.getKey();
            }
            UserOperationLogContext context = this.createContextForJobDefinition(operation, jobDefinitionId, processDefinitionId, processDefinitionKey, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logAttachmentOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            UserOperationLogContext context = this.createContextForTask("Attachment", operation, task, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logVariableOperation(String operation, String executionId, String taskId, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            if (executionId != null) {
                ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(executionId);
                this.logVariableOperation(operation, execution, propertyChange);
            } else if (taskId != null) {
                TaskEntity task = this.getTaskManager().findTaskById(taskId);
                this.logVariableOperation(operation, task, propertyChange);
            }
        }
    }

    public void logVariableOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            String processDefinitionKey = null;
            ProcessDefinitionEntity definition = task.getProcessDefinition();
            if (definition != null) {
                processDefinitionKey = definition.getKey();
            }
            UserOperationLogContext context = this.createContext("Variable", operation, processDefinitionKey, task.getProcessDefinitionId(), task.getProcessInstanceId(), null, null, Arrays.asList(propertyChange));
            context.setTaskId(task.getId());
            context.setExecutionId(task.getExecutionId());
            this.logUserOperations(context);
        }
    }

    public void logVariableOperation(String operation, ExecutionEntity execution, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            String processDefinitionKey = null;
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)execution.getProcessDefinition();
            if (definition != null) {
                processDefinitionKey = definition.getKey();
            }
            UserOperationLogContext context = this.createContext("Variable", operation, processDefinitionKey, execution.getProcessDefinitionId(), execution.getProcessInstanceId(), null, null, Arrays.asList(propertyChange));
            context.setExecutionId(execution.getId());
            this.logUserOperations(context);
        }
    }

    protected UserOperationLogContext createContextForTask(String entityType, String operation, TaskEntity task, List<PropertyChange> propertyChanges) {
        UserOperationLogContext context = this.createContext(entityType, operation);
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(operation)) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        context.setPropertyChanges(propertyChanges);
        ProcessDefinitionEntity definition = task.getProcessDefinition();
        if (definition != null) {
            context.setProcessDefinitionKey(definition.getKey());
        }
        context.setProcessDefinitionId(task.getProcessDefinitionId());
        context.setProcessInstanceId(task.getProcessInstanceId());
        context.setExecutionId(task.getExecutionId());
        context.setCaseDefinitionId(task.getCaseDefinitionId());
        context.setCaseInstanceId(task.getCaseInstanceId());
        context.setCaseExecutionId(task.getCaseExecutionId());
        context.setTaskId(task.getId());
        return context;
    }

    protected UserOperationLogContext createContextForProcessDefinition(String operation, String processDefinitionId, String processDefinitionKey, List<PropertyChange> propertyChanges) {
        return this.createContext("ProcessDefinition", operation, processDefinitionKey, processDefinitionId, null, null, null, propertyChanges);
    }

    protected UserOperationLogContext createContextForProcessInstance(String operation, String processInstanceId, String processDefinitionId, String processDefinitionKey, List<PropertyChange> propertyChanges) {
        return this.createContext("ProcessInstance", operation, processDefinitionKey, processDefinitionId, processInstanceId, null, null, propertyChanges);
    }

    protected UserOperationLogContext createContextForJob(String operation, String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey, List<PropertyChange> propertyChanges) {
        return this.createContext("Job", operation, processDefinitionKey, processDefinitionId, processInstanceId, jobDefinitionId, jobId, propertyChanges);
    }

    protected UserOperationLogContext createContextForJobDefinition(String operation, String jobDefinitionId, String processDefinitionId, String processDefinitionKey, List<PropertyChange> propertyChanges) {
        return this.createContext("JobDefinition", operation, processDefinitionKey, processDefinitionId, null, jobDefinitionId, null, propertyChanges);
    }

    protected UserOperationLogContext createContext(String entityType, String operationType) {
        UserOperationLogContext context = new UserOperationLogContext();
        context.setEntityType(entityType);
        context.setOperationType(operationType);
        return context;
    }

    protected UserOperationLogContext createContext(String entityType, String operationType, String processDefinitionKey, String processDefinitionId, String processInstanceId, String jobDefinitionId, String jobId, List<PropertyChange> propertyChanges) {
        UserOperationLogContext context = this.createContext(entityType, operationType);
        context.setProcessDefinitionKey(processDefinitionKey);
        context.setProcessDefinitionId(processDefinitionId);
        context.setProcessInstanceId(processInstanceId);
        context.setJobDefinitionId(jobDefinitionId);
        context.setJobId(jobId);
        context.setPropertyChanges(propertyChanges);
        return context;
    }
}

