/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import junit.framework.AssertionFailedError;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.LogUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;

public abstract class AbstractProcessEngineTestCase
extends PvmTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY", "ACT_RU_METER_LOG");
    protected ProcessEngine processEngine;
    protected LogUtil.ThreadLogMode threadRenderingMode = DEFAULT_THREAD_LOG_MODE;
    protected String deploymentId;
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected FilterService filterService;

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        log.severe("                                                                                           ");
        try {
            this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
        }
        catch (AssertionFailedError e) {
            log.severe("                                                                                           ");
            log.log(Level.SEVERE, "ASSERTION FAILED: " + (Object)((Object)e), e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.severe("                                                                                           ");
            log.log(Level.SEVERE, "EXCEPTION: " + e, e);
            this.exception = e;
            throw e;
        }
        finally {
            TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
            this.identityService.clearAuthentication();
            this.assertAndEnsureCleanDb();
            ClockUtil.reset();
            this.closeDownProcessEngine();
            this.clearServiceReferences();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.fine("verifying that db is clean after test");
        Map<String, Long> tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.processEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  " + tableName + ": " + count + " record(s)\n");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.severe("                                                                                           ");
            log.severe(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getCommandExecutorTxRequired();
            commandExecutor.execute(new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    PersistenceSession persistenceSession = commandContext.getSession(PersistenceSession.class);
                    persistenceSession.dbSchemaDrop();
                    persistenceSession.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
        this.filterService = this.processEngine.getFilterService();
    }

    protected void clearServiceReferences() {
        this.processEngineConfiguration = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.authorizationService = null;
        this.caseService = null;
        this.filterService = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
    }

    public void assertProcessNotEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new AssertionFailedError("Expected process instance '" + processInstanceId + "' to be still active but it was not in the db");
        }
    }

    public void assertCaseEnded(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance != null) {
            throw new AssertionFailedError("Expected finished case instance '" + caseInstanceId + "' but it was still in the db");
        }
    }

    @Deprecated
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        this.waitForJobExecutorToProcessAllJobs(maxMillisToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 1000L;
        int jobExecutorWaitTime = jobExecutor.getWaitTimeInMillis() * 2;
        if (maxMillisToWait < (long)jobExecutorWaitTime) {
            maxMillisToWait = jobExecutorWaitTime;
        }
        try {
            Timer timer = new Timer();
            InterruptTask task = new InterruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = this.areJobsAvailable();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    @Deprecated
    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        this.waitForJobExecutorOnCondition(maxMillisToWait, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorOnCondition(long maxMillisToWait, Callable<Boolean> condition) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 500L;
        if (maxMillisToWait < (long)(jobExecutor.getWaitTimeInMillis() * 2)) {
            maxMillisToWait = jobExecutor.getWaitTimeInMillis() * 2;
        }
        try {
            Timer timer = new Timer();
            InterruptTask task = new InterruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while waiting on condition: " + e.getMessage(), e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public void executeAvailableJobs() {
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            return;
        }
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (Exception exception) {}
        }
        this.executeAvailableJobs();
    }

    public boolean areJobsAvailable() {
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            if (job.isSuspended() || job.getRetries() <= 0 || job.getDuedate() != null && !ClockUtil.getCurrentTime().after(job.getDuedate())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected List<ActivityInstance> getInstancesForActivitiyId(ActivityInstance activityInstance, String activityId) {
        return this.getInstancesForActivityId(activityInstance, activityId);
    }

    protected List<ActivityInstance> getInstancesForActivityId(ActivityInstance activityInstance, String activityId) {
        ArrayList<ActivityInstance> result = new ArrayList<ActivityInstance>();
        if (activityInstance.getActivityId().equals(activityId)) {
            result.add(activityInstance);
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            result.addAll(this.getInstancesForActivityId(childInstance, activityId));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsUser(String userId, List<String> groupIds, Runnable r) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            this.processEngineConfiguration.setAuthorizationEnabled(true);
            r.run();
        }
        finally {
            this.identityService.setAuthenticatedUserId(null);
            this.processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    public void deployment(BpmnModelInstance ... bpmnModelInstances) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        for (int i = 0; i < bpmnModelInstances.length; ++i) {
            BpmnModelInstance bpmnModelInstance = bpmnModelInstances[i];
            deploymentBuilder.addModelInstance("testProcess-" + i + ".bpmn", bpmnModelInstance);
        }
        this.deploymentId = deploymentBuilder.deploy().getId();
    }

    private static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }

    @Deprecated
    private static class InteruptTask
    extends InterruptTask {
        public InteruptTask(Thread thread) {
            super(thread);
        }
    }
}

