/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BooleanValue;

public class BooleanValueSerializer
extends PrimitiveValueSerializer<BooleanValue> {
    private static final Long TRUE = 1L;
    private static final Long FALSE = 0L;

    public BooleanValueSerializer() {
        super(ValueType.BOOLEAN);
    }

    @Override
    public BooleanValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.booleanValue((Boolean)untypedValue.getValue());
    }

    @Override
    public BooleanValue readValue(ValueFields valueFields) {
        Boolean boolValue = null;
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            boolValue = longValue.equals(TRUE);
        }
        return Variables.booleanValue(boolValue);
    }

    @Override
    public void writeValue(BooleanValue variableValue, ValueFields valueFields) {
        Long longValue = null;
        Boolean boolValue = (Boolean)variableValue.getValue();
        if (boolValue != null) {
            longValue = boolValue != false ? TRUE : FALSE;
        }
        valueFields.setLongValue(longValue);
    }
}

