/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.feel.impl.juel.el;

import camundafeel.javax.el.FunctionMapper;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelLogger;

public class FeelFunctionMapper
extends FunctionMapper {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final SimpleDateFormat FEEL_DATE_AND_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String JUEL_DATE_AND_TIME_METHOD = "dateAndTime";
    protected static final Map<String, Method> methods = new HashMap<String, Method>();

    @Override
    public Method resolveFunction(String prefix, String localName) {
        return methods.get(localName);
    }

    protected static Method getMethod(String name, Class<?> ... parameterTypes) {
        try {
            return FeelFunctionMapper.class.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw LOG.unableToFindMethod(e, name, parameterTypes);
        }
    }

    public static Date parseDateAndTime(String dateAndTimeString) {
        try {
            return FEEL_DATE_AND_TIME_FORMAT.parse(dateAndTimeString);
        }
        catch (ParseException e) {
            throw LOG.invalidDateAndTimeFormat(dateAndTimeString, e);
        }
    }

    static {
        methods.put(JUEL_DATE_AND_TIME_METHOD, FeelFunctionMapper.getMethod("parseDateAndTime", String.class));
    }
}

